/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.costshare;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.impl.unit.UnitAgendaTypeServiceImpl;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.impl.provider.repository.LazyAgendaTree;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="costShareAgendaTypeService")
public class CostShareAgendaTypeServiceImpl
extends UnitAgendaTypeServiceImpl {
    public static final String TYPE_ID = "typeId";
    @Autowired
    @Qualifier(value="repositoryToEngineTranslator")
    private RepositoryToEngineTranslator repositoryToEngineTranslator;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    @Override
    public Agenda loadAgenda(AgendaDefinition agendaDefinition) {
        if (agendaDefinition == null) {
            throw new RiceIllegalArgumentException("agendaDefinition must not be null");
        }
        if (this.repositoryToEngineTranslator == null) {
            return null;
        }
        return new CostShareAgenda(agendaDefinition.getAttributes(), (AgendaTree)new LazyAgendaTree(agendaDefinition, this.repositoryToEngineTranslator), agendaDefinition.getTypeId(), agendaDefinition.isActive());
    }

    private class CostShareAgenda
    extends BasicAgenda {
        private Map<String, String> qualifiers;
        private boolean isActive;

        public CostShareAgenda(Map<String, String> qualifiers, AgendaTree agendaTree, String agendaTypeId, boolean isActive) {
            super(qualifiers, agendaTree);
            this.isActive = isActive;
            String unitNumber = qualifiers.get("Unit Number");
            this.qualifiers = new HashMap<String, String>(qualifiers);
            this.qualifiers.put("costShareAgendaUnits", unitNumber);
        }

        public boolean appliesTo(ExecutionEnvironment environment) {
            if (!this.isActive) {
                return false;
            }
            String environmentId = (String)environment.getSelectionCriteria().getAgendaQualifiers().get(CostShareAgendaTypeServiceImpl.TYPE_ID);
            String agendaId = this.qualifiers.get(CostShareAgendaTypeServiceImpl.TYPE_ID);
            if (environmentId != null && !StringUtils.equals((CharSequence)environmentId, (CharSequence)agendaId)) {
                return false;
            }
            return environment.getSelectionCriteria().getAgendaQualifiers().containsKey("costShareAgendaUnits") && this.appliesToUnit(environment.getSelectionCriteria().getAgendaQualifiers().entrySet());
        }

        protected boolean appliesToUnit(Set<Map.Entry<String, String>> agendaQualifiers) {
            for (Map.Entry<String, String> agendaQualifier : agendaQualifiers) {
                String agendaQualifierValue = this.qualifiers.get(agendaQualifier.getKey());
                String environmentQualifierValue = agendaQualifier.getValue();
                if (!"costShareAgendaUnits".equals(agendaQualifier.getKey())) continue;
                return CostShareAgendaTypeServiceImpl.this.unitService.appliesToUnit(agendaQualifierValue, environmentQualifierValue);
            }
            return false;
        }
    }
}

