/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person;

import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="kcPersonLookupable")
@Scope(value="prototype")
public class KcPersonLookupable
extends LookupableImpl {
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    public List<?> performSearch(LookupForm form, Map<String, String> searchCriteria, boolean unbounded) {
        this.getKcPersonService().modifyFieldValues(searchCriteria);
        this.convertToPersonImpl(form.getViewPostMetadata().getLookupCriteria());
        List personResults = (List)super.performSearch(form, searchCriteria, unbounded);
        this.convertToKcPerson(form.getViewPostMetadata().getLookupCriteria(), searchCriteria);
        return this.getKcPersonService().createKcPersonsFromPeople(personResults);
    }

    protected void convertToPersonImpl(Map<String, Map<String, Object>> lookupCriteria) {
        lookupCriteria.put("principalName", lookupCriteria.get("userName"));
        lookupCriteria.put("principalId", lookupCriteria.get("personId"));
        lookupCriteria.put("phoneNumber", lookupCriteria.get("officePhone"));
        lookupCriteria.put("primaryDepartmentCode", lookupCriteria.get("organizationIdentifier"));
        this.setDataObjectClass(PersonImpl.class);
    }

    protected void convertToKcPerson(Map<String, Map<String, Object>> lookupCriteria, Map<String, String> searchCriteria) {
        lookupCriteria.remove("principalName");
        lookupCriteria.remove("principalId");
        lookupCriteria.remove("phoneNumber");
        lookupCriteria.remove("primaryDepartmentCode");
        searchCriteria.clear();
        this.setDataObjectClass(KcPerson.class);
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

