/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="kcPersonLookupableHelperServiceKNS")
@Scope(value="prototype")
@Lazy
public class KcPersonLookupableHelperServiceKNSImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String PERSON_CAMPUS_CODE_FIELD = "campusCode";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = "org.kuali.rice.location.impl.campus.CampusBo";
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    public List<Row> getRows() {
        List rows = super.getRows();
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(PERSON_CAMPUS_CODE_FIELD)) continue;
                field.setFieldConversions("code:" + field.getPropertyName());
                field.setLookupParameters(field.getPropertyName() + ":code");
                field.setInquiryParameters(field.getPropertyName() + ":code");
                field.setQuickFinderClassNameImpl(CAMPUS_LOOKUPABLE_CLASS_NAME);
                field.setFieldDirectInquiryEnabled(true);
                if (!multiCampusEnabled || !StringUtils.isBlank((CharSequence)field.getDefaultValue())) continue;
                String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
                field.setDefaultValue(campusCode);
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return rows;
    }

    public List<KcPerson> getSearchResults(Map<String, String> fieldValues) {
        this.kcPersonService.modifyFieldValues(fieldValues);
        this.businessObjectClass = PersonImpl.class;
        List personResults = super.getSearchResults(fieldValues);
        this.businessObjectClass = KcPerson.class;
        return this.kcPersonService.createKcPersonsFromPeople(personResults);
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }
}

