/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.rolodex;

import java.util.List;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.impl.rolodex.RolodexDao;
import org.kuali.coeus.common.impl.rolodex.RolodexDaoOjb;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.document.Document;

public class RolodexMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        return super.processCustomRouteDocumentBusinessRules(document);
    }

    @Override
    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        Rolodex newRolodex;
        Boolean enforceUniqueEmail = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "isEnforceUniqueEmailEnabled", Boolean.valueOf(false));
        String maintenanceAction = document.getNewMaintainableObject().getMaintenanceAction();
        if (enforceUniqueEmail.booleanValue() && !maintenanceAction.equals("Delete") && !maintenanceAction.equals("Edit") && !this.isEmailUnique(newRolodex = (Rolodex)document.getDocumentBusinessObject()).booleanValue()) {
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.emailAddress", "error.rolodex.emailAddress.unique", new String[]{"Email Address"});
        }
        return super.processGlobalRouteDocumentBusinessRules(document);
    }

    private Boolean isEmailUnique(Rolodex rolodex) {
        List<Rolodex> rolodexList = this.getRolodexDao().getRolodexByEmail(rolodex.getEmailAddress());
        return rolodexList.size() <= 1;
    }

    private RolodexDaoOjb getRolodexDao() {
        return (RolodexDaoOjb)KcServiceLocator.getService(RolodexDao.class);
    }

    private ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }
}

