/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgenda;

public class UnitAgenda
extends BasicAgenda {
    public static final String TYPE_ID = "typeId";
    private UnitService unitService;
    private Map<String, String> qualifiers;
    private boolean isActive;

    public UnitAgenda(Map<String, String> qualifiers, AgendaTree agendaTree, String agendaTypeId, boolean isActive) {
        super(qualifiers, agendaTree);
        this.isActive = isActive;
        this.qualifiers = new HashMap<String, String>(qualifiers);
        this.qualifiers.put(TYPE_ID, agendaTypeId);
    }

    public boolean appliesTo(ExecutionEnvironment environment) {
        if (!this.isActive) {
            return false;
        }
        String environmentId = (String)environment.getSelectionCriteria().getAgendaQualifiers().get(TYPE_ID);
        String agendaId = this.qualifiers.get(TYPE_ID);
        if (environmentId != null && !StringUtils.equals((CharSequence)environmentId, (CharSequence)agendaId)) {
            return false;
        }
        Set agendaQualifiers = environment.getSelectionCriteria().getAgendaQualifiers().entrySet();
        for (Map.Entry agendaQualifier : agendaQualifiers) {
            String agendaQualifierValue = this.qualifiers.get(agendaQualifier.getKey());
            String environmentQualifierValue = (String)agendaQualifier.getValue();
            if (!"Unit Number".equals(agendaQualifier.getKey())) continue;
            return this.unitService.appliesToUnit(agendaQualifierValue, environmentQualifierValue);
        }
        return false;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

