/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="unitPrimaryEmploymentRoleTypeService")
public class UnitPrimaryEmploymentRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = LogManager.getLogger(UnitPrimaryEmploymentRoleTypeServiceImpl.class);
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String documentUnitNumber = qualification.get("unitNumber");
        if (StringUtils.isBlank((CharSequence)documentUnitNumber)) {
            return List.of();
        }
        List<String> hierarchyUnits = this.getActiveHierarchyUnitNames(roleName);
        if (hierarchyUnits.isEmpty()) {
            LOG.warn(String.format("Role %s does not correspond to a valid unit!", roleName));
            return List.of();
        }
        if (!hierarchyUnits.contains(documentUnitNumber)) {
            return List.of();
        }
        return this.getPeopleForUnits(hierarchyUnits).entrySet().stream().flatMap(entry -> this.createRoleMemberships((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toList());
    }

    protected List<String> getActiveHierarchyUnitNames(String topUnit) {
        return Stream.concat(Stream.of(this.unitService.getUnit(topUnit)), this.unitService.getAllSubUnits(topUnit).stream()).filter(Objects::nonNull).filter(Unit::isActive).map(Unit::getUnitNumber).collect(Collectors.toList());
    }

    protected Map<String, Set<String>> getPeopleForUnits(Collection<String> units) {
        return this.kcPersonService.findPersonEmploymentUnits(units, true);
    }

    protected Stream<RoleMembership> createRoleMemberships(String personId, Set<String> units) {
        return units.stream().map(unit -> RoleMembership.Builder.create(null, null, (String)personId, (MemberType)MemberType.PRINCIPAL, Map.of("unitNumber", unit)).build());
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String documentUnitNumber = qualification.get("unitNumber");
        if (StringUtils.isBlank((CharSequence)documentUnitNumber)) {
            return false;
        }
        List<String> hierarchyUnits = this.getActiveHierarchyUnitNames(roleName);
        if (!hierarchyUnits.contains(documentUnitNumber)) {
            return false;
        }
        KcPerson person = this.kcPersonService.getKcPersonByPersonId(principalId);
        return hierarchyUnits.contains(person.getOrganizationIdentifier());
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

