/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl.bo;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.bo.NotificationModuleRole;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class NotificationModuleRoleMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 5816092888763757328L;
    private static final String NOTIFICATION_MODULE_ROLE_ID_SEQUENCE_NAME = "SEQ_NTFCTN_MODULE_ROLE_ID";
    private static final String NOTIFICATION_MODULE_ROLE_SECTION_ID = "Edit Notification Module Role";
    private static final String NOTIFICATION_MODULE_ROLE_ID_NAME = "notificationModuleRoleId";
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        NotificationModuleRole notificationModuleRole = (NotificationModuleRole)this.getBusinessObject();
        Long nextNotificationModuleRoleId = this.getSequenceAccessorService().getNextAvailableSequenceNumber(NOTIFICATION_MODULE_ROLE_ID_SEQUENCE_NAME, NotificationModuleRole.class);
        notificationModuleRole.setNotificationModuleRoleId(nextNotificationModuleRoleId);
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            if (!StringUtils.equals((CharSequence)section.getSectionId(), (CharSequence)NOTIFICATION_MODULE_ROLE_SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)NOTIFICATION_MODULE_ROLE_ID_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
        return sections;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KcServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

