/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchInstitutionalProposalSerializer;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.kuali.rice.krad.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElasticsearchAwardSerializer
extends ElasticsearchDocumentSerializer {
    @Autowired
    @Qualifier(value="esInstitutionalProposalSerializer")
    private ElasticsearchInstitutionalProposalSerializer institutionalProposalSerializer;

    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        AwardDocument document = (AwardDocument)doc;
        Award award = document.getAward();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(String.valueOf(award.getAwardId()));
        esDoc.setNamespace(document.getNamespace());
        esDoc.setAccountId(award.getAccountNumber());
        esDoc.setSequenceNumber(award.getSequenceNumber());
        esDoc.setSequenceStatus(award.getAwardSequenceStatus());
        esDoc.setTypeCode(String.valueOf(award.getAwardTypeCode()));
        award.refreshReferenceObject("awardType");
        esDoc.setTypeDescription(award.getAwardType().getDescription());
        esDoc.setStartDate(DateUtils.toUtc(award.getAwardEffectiveDate()));
        esDoc.setStatusCode(String.valueOf(award.getStatusCode()));
        esDoc.setStatusDescription(award.getStatusDescription());
        esDoc.setEndDate(DateUtils.toUtc(award.findLatestFinalExpirationDate()));
        if (award.getAwardExecutionDate() != null) {
            esDoc.addExecutionDate(DateUtils.toUtc(award.getAwardExecutionDate()));
        }
        esDoc.setSponsorNumber(award.getSponsorAwardNumber());
        this.setCommonFields(esDoc, award);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, Award award) {
        esDoc.setAwardNumber(award.getAwardNumber());
        esDoc.setTitle(award.getTitle());
        esDoc.setSponsorCode(award.getSponsorCode());
        esDoc.setSponsorName(award.getSponsorName());
        esDoc.setPrimeSponsorCode(award.getPrimeSponsorCode());
        esDoc.setPrimeSponsorName(award.getPrimeSponsorName());
        esDoc.setLeadUnitNumber(award.getLeadUnitNumber());
        esDoc.setLeadUnitName(award.getLeadUnitName());
        this.setAwardPersonFields(esDoc, award);
        this.setIpAndPdSpecificFields(esDoc, award);
    }

    protected void setAwardPersonFields(GrantsSearchDocument esDoc, Award award) {
        Map<String, Long> personnelCriteria = Map.of("awardId", award.getAwardId());
        Collection projectPersons = this.businessObjectService.findMatching(AwardPerson.class, personnelCriteria);
        super.setPersonFields(esDoc, projectPersons);
        projectPersons.stream().filter(AwardPerson::isPrincipalInvestigator).findFirst().map(awardPerson -> awardPerson.getLastName() + ", " + awardPerson.getFirstName()).ifPresent(esDoc::setPrincipalInvestigatorName);
    }

    protected void setIpAndPdSpecificFields(GrantsSearchDocument esDoc, Award award) {
        Collection<String> fundingIPNumbers = this.getAwardFundingProposalNumbers(award);
        fundingIPNumbers.forEach(esDoc::addProposalNumber);
        this.setPdSpecificFields(esDoc, this.institutionalProposalSerializer.getDevProposalsForIPs(fundingIPNumbers));
    }

    protected Collection<String> getAwardFundingProposalNumbers(Award award) {
        Collection fundingProposalIds;
        if (CollectionUtils.isNotEmpty(award.getAllFundingProposals()) && CollectionUtils.isNotEmpty((Collection)(fundingProposalIds = (Collection)award.getAllFundingProposals().stream().map(AwardFundingProposal::getProposalId).collect(Collectors.toSet())))) {
            return this.businessObjectService.findMatching(InstitutionalProposalBoLite.class, Map.of("proposalId", fundingProposalIds)).stream().map(InstitutionalProposalBoLite::getProposalNumber).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of(AwardPermissionConstants.VIEW_AWARD.getAwardPermission());
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof AwardDocument;
    }
}

