/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.auth;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalCostShareUnitAdministratorDerivedRoleTypeService")
public class ProposalCostshareUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String proposalNumber = qualifiers.get("proposal");
        List<Object> result = new ArrayList();
        if (proposalNumber != null) {
            DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
            Set<String> units = this.getApplicableUnits(proposal);
            String costShareAdministratorTypeCode = this.getCostShareAdministratorTypeCode();
            if (units != null) {
                result = units.stream().filter(unit -> StringUtils.isNotBlank((CharSequence)unit)).map(unit -> this.unitService.retrieveUnitAdministratorsByUnitNumberAndType((String)unit, costShareAdministratorTypeCode)).flatMap(l -> l.stream()).collect(Collectors.toList());
            }
        }
        return result;
    }

    public String getCostShareAdministratorTypeCode() {
        return this.parameterService.getParameterValueAsString("KC-PD", "All", "COST_SHARE_ADMINISTRATOR_TYPE_CODE");
    }

    public Set<String> getApplicableUnits(DevelopmentProposal proposal) {
        ProposalDevelopmentBudgetExt budget = proposal.getFinalBudget();
        if (Objects.isNull(budget) || Objects.isNull(budget.getBudgetCostShares()) || budget.getBudgetCostShares().size() == 0) {
            return new HashSet<String>();
        }
        return budget.getBudgetCostShares().stream().filter(budgetCostShare -> budgetCostShare.getUnit() != null).map(budgetCostShare -> budgetCostShare.getUnit().getUnitNumber()).collect(Collectors.toSet());
    }
}

