/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class LeadUnitValuesFinder
extends UifKeyValuesFinderBase {
    private ProposalDevelopmentService proposalDevelopmentService;

    protected ProposalDevelopmentService getProposalDevelopmentService() {
        if (this.proposalDevelopmentService == null) {
            this.proposalDevelopmentService = KcServiceLocator.getService(ProposalDevelopmentService.class);
        }
        return this.proposalDevelopmentService;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        ProposalDevelopmentService authService = this.getProposalDevelopmentService();
        List<Unit> userUnits = authService.getUnitsForCreateProposal(userId);
        Collections.sort(userUnits, new Comparator(){

            public int compare(Object o1, Object o2) {
                Unit unit1 = (Unit)o1;
                Unit unit2 = (Unit)o2;
                return unit1.getUnitNumber().compareTo(unit2.getUnitNumber());
            }
        });
        for (Unit unit : userUnits) {
            keyValues.add((KeyValue)new ConcreteKeyValue(unit.getUnitNumber(), unit.getUnitNumber() + " - " + unit.getUnitName()));
        }
        return keyValues;
    }
}

