/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.editable;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetChangedData;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetDataOverrideEvent;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetDataOverrideRule;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalBudgetDataOverrideRule
extends KcTransactionalDocumentRuleBase
implements BudgetDataOverrideRule {
    private static Map<String, String> validationClasses = new HashMap<String, String>();
    private static final String DATE = "DATE";
    private KcPersistenceStructureService kcPersistenceStructureService;
    private DateTimeService dateTimeService;

    @Override
    public boolean processBudgetDataOverrideRules(BudgetDataOverrideEvent budgetDataOverrideEvent) {
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)budgetDataOverrideEvent.getDocument()).getDevelopmentProposal();
        ProposalDevelopmentBudgetExt finalBudget = developmentProposal.getFinalBudget();
        BudgetChangedData budgetOverriddenData = budgetDataOverrideEvent.getBudgetChangedData();
        boolean valid = true;
        String overriddenValue = budgetOverriddenData.getChangedValue();
        Map<String, String> columnToAttributesMap = this.getKcPersistenceStructureService().getDBColumnToObjectAttributeMap(Budget.class);
        String overriddenName = this.getDataDictionaryService().getAttributeErrorLabel(Budget.class, columnToAttributesMap.get(budgetOverriddenData.getColumnName()));
        Boolean isRequiredField = this.getDataDictionaryService().isAttributeRequired(Budget.class, columnToAttributesMap.get(budgetOverriddenData.getColumnName()));
        boolean isPrimitiveField = this.getDataObjectService().wrap((Object)finalBudget).getPropertyType(budgetOverriddenData.getAttributeName()).isPrimitive();
        if (StringUtils.isEmpty((CharSequence)budgetOverriddenData.getColumnName())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.columnName", "error.alterproposaldata.nofieldtoedit", new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)budgetOverriddenData.getChangedValue())) {
            valid &= this.validateAttributeFormat(budgetDataOverrideEvent, columnToAttributesMap);
        }
        if ((isRequiredField.booleanValue() || isPrimitiveField) && StringUtils.isEmpty((CharSequence)overriddenValue)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.required", new String[]{overriddenName});
        }
        if (StringUtils.isNotEmpty((CharSequence)budgetOverriddenData.getComments())) {
            int commentsMaxLength = this.getDataDictionaryService().getAttributeMaxLength(BudgetChangedData.class, "comments");
            String commentsLabel = this.getDataDictionaryService().getAttributeLabel(BudgetChangedData.class, "comments");
            if (commentsMaxLength < budgetOverriddenData.getComments().length()) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.comments", "error.maxLength", new String[]{commentsLabel, "" + commentsMaxLength});
                return false;
            }
        }
        return valid;
    }

    private boolean validateAttributeFormat(BudgetDataOverrideEvent budgetDataOverrideEvent, Map<String, String> columnToAttributesMap) {
        String currentValueStr;
        Object currentValue;
        Pattern validationExpression;
        BudgetChangedData budgetOverriddenData = budgetDataOverrideEvent.getBudgetChangedData();
        String overriddenValue = budgetOverriddenData.getChangedValue();
        String changedValueLabel = this.getDataDictionaryService().getAttributeLabel(BudgetChangedData.class, "changedValue");
        String dataType = null;
        Integer maxLength = -1;
        if (budgetOverriddenData.getEditableColumn() != null) {
            dataType = budgetOverriddenData.getEditableColumn().getDataType();
            maxLength = budgetOverriddenData.getEditableColumn().getDataLength();
        }
        ValidationPattern validationPattern = null;
        if (DATE.equalsIgnoreCase(dataType)) {
            try {
                this.getDateTimeService().convertToDate(overriddenValue);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        String validationClassName = validationClasses.get(dataType);
        if (StringUtils.isNotEmpty((CharSequence)validationClassName)) {
            try {
                validationPattern = (ValidationPattern)Class.forName(validationClasses.get(dataType)).newInstance();
                if (dataType.equalsIgnoreCase("STRING")) {
                    ((AnyCharacterValidationPattern)validationPattern).setAllowWhitespace(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in instantiating a ValidationPatternClass for Budget Data Overriding", e);
            }
        }
        if (validationPattern != null && (validationExpression = validationPattern.getRegexPattern()) != null && !validationExpression.pattern().equals(".*") && !validationExpression.matcher(overriddenValue).matches()) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidFormat", new String[]{changedValueLabel, overriddenValue});
            return false;
        }
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)budgetDataOverrideEvent.getDocument()).getDevelopmentProposal();
        ProposalDevelopmentBudgetExt finalBudget = developmentProposal.getFinalBudget();
        Object object = currentValue = finalBudget != null ? ObjectUtils.getPropertyValue((Object)finalBudget, (String)columnToAttributesMap.get(budgetOverriddenData.getColumnName())) : null;
        if (currentValue instanceof ScaleTwoDecimal) {
            try {
                Double.parseDouble(overriddenValue);
            }
            catch (Exception e) {
                GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.invalidNumber", new String[]{changedValueLabel, overriddenValue});
                return false;
            }
        }
        if (maxLength != null && maxLength < overriddenValue.length() && !(currentValue instanceof Boolean)) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.maxLength", new String[]{changedValueLabel, maxLength.toString()});
            return false;
        }
        String string = currentValueStr = currentValue != null ? currentValue.toString() : "";
        if (DATE.equalsIgnoreCase(budgetOverriddenData.getEditableColumn().getDataType()) && currentValue != null) {
            currentValueStr = this.getDateTimeService().toString((Date)currentValue, "MM/dd/yyyy");
        }
        if (StringUtils.isNotEmpty((CharSequence)currentValueStr) && currentValueStr.equalsIgnoreCase(overriddenValue) && !(currentValue instanceof Boolean)) {
            GlobalVariables.getMessageMap().putError("newBudgetChangedData.changedValue", "error.budgetData.override.samevalue", new String[]{budgetOverriddenData.getEditableColumn().getColumnLabel(), budgetOverriddenData.getDisplayValue() != null ? budgetOverriddenData.getDisplayValue() : overriddenValue});
            return false;
        }
        return true;
    }

    protected KcPersistenceStructureService getKcPersistenceStructureService() {
        if (this.kcPersistenceStructureService == null) {
            this.kcPersistenceStructureService = KcServiceLocator.getService(KcPersistenceStructureService.class);
        }
        return this.kcPersistenceStructureService;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    static {
        validationClasses.put("STRING", AnyCharacterValidationPattern.class.getName());
        validationClasses.put("NUMBER", NumericValidationPattern.class.getName());
    }
}

