/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.SubmitToSponsorEvent;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="submitToSponsorRule")
public class SubmitToSponsorRule {
    @Autowired
    @Qualifier(value="parameterService")
    ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    GlobalVariableService globalVariableService;

    @KcEventMethod
    public Boolean validateIncompleteAttachments(SubmitToSponsorEvent submitToSponsorEvent) {
        Boolean valid = true;
        Boolean auditIncompleteAttachments = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS");
        if (auditIncompleteAttachments == null) {
            throw new RuntimeException("System parameter AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS is missing or invalid");
        }
        if (!auditIncompleteAttachments.booleanValue()) {
            valid = valid & this.validateAttachments(submitToSponsorEvent.getProposalDevelopmentDocument().getDevelopmentProposal().getNarratives(), "Proposal Attachments", "document.developmentProposal.narratives[%d].moduleStatusCode", "error.document.narrativestatuscode.not.complete", "PropDev-AttachmentsPage-ProposalSection");
            valid = valid & this.validateAttachments(submitToSponsorEvent.getProposalDevelopmentDocument().getDevelopmentProposal().getInstituteAttachments(), "Internal Attachments", "document.developmentProposal.instituteAttachments[%d].moduleStatusCode", "error.document.internalattachment.statuscode.not.complete", "PropDev-AttachmentsPage-InternalSection");
        }
        return valid;
    }

    protected Boolean validateAttachments(List<Narrative> narratives, String sectionName, String errorKey, String messageKey, String sectionId) {
        int index = 0;
        for (Narrative attachment : narratives) {
            if (attachment.getModuleStatusCode().equals("I")) {
                this.getAuditErrors(sectionName).add(new AuditError(String.format(errorKey, index), messageKey, "PropDev-AttachmentsPage." + sectionId));
                return false;
            }
            ++index;
        }
        return true;
    }

    protected List<AuditError> getAuditErrors(String sectionName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Attachments." + sectionName;
        if (!this.getGlobalVariableService().getAuditErrorMap().containsKey(clusterKey)) {
            this.getGlobalVariableService().getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, "Error"));
        } else {
            auditErrors = this.getGlobalVariableService().getAuditErrorMap().get(clusterKey).getAuditErrorList();
        }
        return auditErrors;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

