/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.attachment;

import java.util.ArrayList;
import java.util.HashMap;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.attachment.PropPerDocType;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalPersonBiographyService")
public class ProposalPersonBiographyServiceImpl
implements ProposalPersonBiographyService {
    public static final String OTHER_DOCUMENT_TYPE_DESCRIPTION = "Other";
    private static final String DOC_TYPE_DESCRIPTION = "description";
    public static final String PROP_PER_DOC_TYPE = "propPerDocType";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;

    @Override
    public void addProposalPersonBiography(ProposalDevelopmentDocument proposaldevelopmentDocument, ProposalPersonBiography proposalPersonBiography) {
        proposalPersonBiography.setDevelopmentProposal(proposaldevelopmentDocument.getDevelopmentProposal());
        proposalPersonBiography.setBiographyNumber(proposaldevelopmentDocument.getDocumentNextValue("proposalDevelopment.proposalPersonBiography.biographyNumber"));
        proposalPersonBiography.setPropPerDocType(new PropPerDocType());
        ProposalPerson proposalPerson = this.getPerson(proposaldevelopmentDocument.getDevelopmentProposal(), proposalPersonBiography.getProposalPersonNumber());
        if (proposalPerson != null) {
            proposalPersonBiography.setPersonId(proposalPerson.getPersonId());
            proposalPersonBiography.setRolodexId(proposalPerson.getRolodexId());
        }
        proposalPersonBiography.getPropPerDocType().setCode(proposalPersonBiography.getDocumentTypeCode());
        proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().add(proposalPersonBiography);
    }

    @Override
    public void prepareProposalPersonBiographyForSave(DevelopmentProposal developmentProposal, ProposalPersonBiography biography) {
        ProposalPerson proposalPerson;
        biography.setPropPerDocType(new PropPerDocType());
        biography.getPropPerDocType().setCode(biography.getDocumentTypeCode());
        biography.refreshReferenceObject(PROP_PER_DOC_TYPE);
        if (biography.getProposalPersonNumber() != null && (proposalPerson = this.getPerson(developmentProposal, biography.getProposalPersonNumber())) != null) {
            biography.setPersonId(proposalPerson.getPersonId());
            biography.setRolodexId(proposalPerson.getRolodexId());
        }
    }

    @Override
    public void removePersonnelAttachmentForDeletedPerson(ProposalDevelopmentDocument proposaldevelopmentDocument, ProposalPerson person) {
        ArrayList<ProposalPersonBiography> personAttachments = new ArrayList<ProposalPersonBiography>();
        for (ProposalPersonBiography proposalPersonBiography : proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios()) {
            if (!proposalPersonBiography.getProposalPersonNumber().equals(person.getProposalPersonNumber())) continue;
            personAttachments.add(proposalPersonBiography);
        }
        if (!personAttachments.isEmpty()) {
            proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().removeAll(personAttachments);
        }
    }

    @Override
    public void deleteProposalPersonBiography(ProposalDevelopmentDocument proposaldevelopmentDocument, int lineToDelete) {
        ProposalPersonBiography proposalPersonBiography = proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().get(lineToDelete);
        proposaldevelopmentDocument.getDevelopmentProposal().getPropPersonBios().remove(proposalPersonBiography);
        this.getDataObjectService().delete((Object)proposalPersonBiography);
    }

    protected ProposalPerson getPerson(DevelopmentProposal developmentProposal, Integer proposalPersonNumber) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            if (!proposalPersonNumber.equals(person.getProposalPersonNumber())) continue;
            return person;
        }
        return null;
    }

    @Override
    public PropPerDocType findPropPerDocTypeForOther() {
        HashMap<String, String> narrativeTypeMap = new HashMap<String, String>();
        narrativeTypeMap.put(DOC_TYPE_DESCRIPTION, OTHER_DOCUMENT_TYPE_DESCRIPTION);
        return (PropPerDocType)this.getDataObjectService().findMatching(PropPerDocType.class, QueryByCriteria.Builder.andAttributes(narrativeTypeMap).build()).getResults().get(0);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

