/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityLookupKradKnsHelperService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupableImpl;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="s2sOpportunityLookupable")
@Scope(value="prototype")
public class S2sOpportunityLookupable
extends LookupableImpl {
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="s2sOpportunityLookupKradKnsHelperService")
    private S2sOpportunityLookupKradKnsHelperService s2sOpportunityLookupKradKnsHelperService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public List<?> performSearch(LookupForm form, Map<String, String> searchCriteria, boolean unbounded) {
        String providerCode = searchCriteria.get("providerCode");
        String cfdaNumber = searchCriteria.get("cfdaNumber");
        String opportunityId = searchCriteria.get("opportunityId");
        String packageId = searchCriteria.get("packageId");
        String competitionId = searchCriteria.get("competitionId");
        List<S2sOpportunity> opportunities = this.s2sOpportunityLookupKradKnsHelperService.performSearch(providerCode, cfdaNumber, competitionId, opportunityId, packageId);
        if (CollectionUtils.isEmpty(opportunities)) {
            this.addNotFoundMessage();
        }
        return opportunities;
    }

    public String buildCreatePropActionHref(S2sOpportunity opportunity) {
        Properties parameters = new Properties();
        parameters.put("command", "initiate");
        parameters.put("viewId", "PropDev-InitiateView");
        parameters.put("s2sOpportunityCfdasSerialized", opportunity.getS2sOpportunityCfdasSerialized());
        parameters.put("opportunityId", opportunity.getOpportunityId() != null ? opportunity.getOpportunityId() : "");
        parameters.put("opportunityTitle", opportunity.getOpportunityTitle() != null ? opportunity.getOpportunityTitle() : "");
        parameters.put("openingDate", opportunity.getOpeningDate() != null ? this.getDateTimeService().toDateTimeString(opportunity.getOpeningDate().getTime()) : "");
        parameters.put("instructionUrl", opportunity.getInstructionUrl() != null ? opportunity.getInstructionUrl() : "");
        parameters.put("competitionId", opportunity.getCompetitionId() != null ? opportunity.getCompetitionId() : "");
        parameters.put("packageId", opportunity.getPackageId() != null ? opportunity.getPackageId() : "");
        parameters.put("schemaUrl", opportunity.getSchemaUrl() != null ? opportunity.getSchemaUrl() : "");
        parameters.put("providerCode", opportunity.getProviderCode());
        return UrlFactory.parameterizeUrl((String)this.getDocumentTypeService().getDocumentTypeByName("ProposalDevelopmentDocument").getResolvedDocumentHandlerUrl(), (Properties)parameters);
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    protected void addNotFoundMessage() {
        MessageMap messageMap = this.globalVariableService.getMessageMap();
        messageMap.putInfoForSectionId("LookupResultMessages", "lookup.results.none.found", new String[0]);
    }

    public S2sOpportunityLookupKradKnsHelperService getS2sOpportunityLookupKradKnsHelperService() {
        return this.s2sOpportunityLookupKradKnsHelperService;
    }

    public void setS2sOpportunityLookupKradKnsHelperService(S2sOpportunityLookupKradKnsHelperService s2sOpportunityLookupKradKnsHelperService) {
        this.s2sOpportunityLookupKradKnsHelperService = s2sOpportunityLookupKradKnsHelperService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

