/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.kuali.coeus.sys.api.model.ScaleThreeDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.core.web.format.BigDecimalFormatter;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.Formatter;

public class GlobalFormatterRegistry
implements PlugIn {
    private static final Map<Class<?>, Class<? extends Formatter>> KC_FORMATTERS;
    private ActionServlet servlet;
    private ModuleConfig config;
    private final Map<Class<?>, Class<? extends Formatter>> previousRegisters = new HashMap();

    public void init(ActionServlet aServlet, ModuleConfig aConfig) throws ServletException {
        this.servlet = aServlet;
        this.config = aConfig;
        this.register();
    }

    public void destroy() {
        this.servlet = null;
        this.config = null;
        this.deRegister();
    }

    private void register() {
        for (Map.Entry<Class<?>, Class<Formatter>> entry : KC_FORMATTERS.entrySet()) {
            this.previousRegisters.put(entry.getKey(), Formatter.formatterForType(entry.getKey()));
            Formatter.registerFormatter(entry.getKey(), entry.getValue());
        }
    }

    private void deRegister() {
        for (Map.Entry<Class<?>, Class<Formatter>> entry : this.previousRegisters.entrySet()) {
            Formatter.registerFormatter(entry.getKey(), entry.getValue());
        }
        this.previousRegisters.clear();
    }

    static {
        HashMap<Class, Class> temp = new HashMap<Class, Class>();
        temp.put(ScaleTwoDecimal.class, ScaleTwoDecimalFormatter.class);
        temp.put(ScaleThreeDecimal.class, ScaleThreeDecimalFormatter.class);
        KC_FORMATTERS = Collections.unmodifiableMap(temp);
    }

    public static class ScaleTwoDecimalFormatter
    extends BigDecimalFormatter {
        private static final long serialVersionUID = 8395988033199649377L;
        private static Logger LOG = LogManager.getLogger(ScaleTwoDecimalFormatter.class);

        protected Object convertToObject(String target) {
            return new ScaleTwoDecimal((BigDecimal)super.convertToObject(target));
        }

        public Object format(Object obj) {
            Object string;
            if (LOG.isTraceEnabled()) {
                LOG.trace("format '" + obj + "'");
            }
            if (obj == null) {
                return null;
            }
            NumberFormat formatter = NumberFormat.getNumberInstance();
            ((DecimalFormat)formatter).setParseBigDecimal(true);
            ((DecimalFormat)formatter).setDecimalSeparatorAlwaysShown(true);
            try {
                ScaleTwoDecimal number = (ScaleTwoDecimal)obj;
                string = formatter.format(number.doubleValue());
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new FormatException("formatting", "error.bigDecimal", obj.toString(), (Throwable)e);
            }
            if (obj.toString().length() > 15) {
                return obj.toString();
            }
            if (StringUtils.isNotBlank((CharSequence)string)) {
                if (((String)string).indexOf(".") == ((String)string).length() - 1) {
                    string = (String)string + "00";
                } else if (((String)string).indexOf(".") == ((String)string).length() - 2) {
                    string = (String)string + "0";
                }
            }
            return string;
        }
    }

    public static class ScaleThreeDecimalFormatter
    extends BigDecimalFormatter {
        private static final long serialVersionUID = 4658319828434873892L;

        protected Object convertToObject(String target) {
            return new ScaleThreeDecimal((BigDecimal)super.convertToObject(target));
        }

        public Object format(Object obj) {
            return super.format(super.convertToObject(obj.toString()));
        }
    }
}

