/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.keyvalue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="dataObjectValuesFinder")
public class DataObjectValuesFinder
extends UifKeyValuesFinderBase {
    private static final Logger LOG = LogManager.getLogger(DataObjectValuesFinder.class);
    private static final long serialVersionUID = 1L;
    protected Class<?> dataObjectClass;
    protected String keyAttributeName;
    protected String labelAttributeName;
    protected boolean includeKeyInDescription = false;
    protected String blankRowValue = "select";
    protected Map<String, String> matchingCriteria = new HashMap<String, String>();
    protected String orderByField;
    protected boolean orderDescending;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        try {
            ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
            if (StringUtils.isNotEmpty((CharSequence)this.orderByField)) {
                orderByFields.add(OrderByField.Builder.create((String)this.orderByField, (OrderDirection)(this.orderDescending ? OrderDirection.DESCENDING : OrderDirection.ASCENDING)).build());
            }
            List objects = this.matchingCriteria == null || this.matchingCriteria.isEmpty() ? this.getDataObjectService().findMatching(this.dataObjectClass, QueryByCriteria.Builder.create().setOrderByFields(orderByFields).build()).getResults() : this.getDataObjectService().findMatching(this.dataObjectClass, QueryByCriteria.Builder.andAttributes(this.matchingCriteria).setOrderByFields(orderByFields).build()).getResults();
            if (this.isAddBlankOption()) {
                labels.add((KeyValue)new ConcreteKeyValue("", this.blankRowValue));
            }
            for (Object object : objects) {
                Object key = PropertyUtils.getProperty(object, (String)this.keyAttributeName);
                Object label = (String)PropertyUtils.getProperty(object, (String)this.labelAttributeName);
                if (this.includeKeyInDescription) {
                    label = key + " - " + (String)label;
                }
                labels.add((KeyValue)new ConcreteKeyValue(key.toString(), (String)label));
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while trying to build keyValues List: " + this, (Throwable)e);
        }
        return labels;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    public void setIncludeKeyInDescription(boolean includeKeyInDescription) {
        this.includeKeyInDescription = includeKeyInDescription;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public void setLabelAttributeName(String labelAttributeName) {
        this.labelAttributeName = labelAttributeName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistableDataObjectValuesFinder [dataObjectClass=").append(this.dataObjectClass).append(", keyAttributeName=").append(this.keyAttributeName).append(", labelAttributeName=").append(this.labelAttributeName).append(", includeKeyInDescription=").append(this.includeKeyInDescription).append(", includeBlankRow=").append(this.isAddBlankOption()).append("]");
        return builder.toString();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setBlankRowValue(String blankRowValue) {
        this.blankRowValue = blankRowValue;
    }

    public Map<String, String> getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public void setMatchingCriteria(Map<String, String> matchingCriteria) {
        this.matchingCriteria = matchingCriteria;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public String getOrderByField() {
        return this.orderByField;
    }

    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    public boolean isOrderDescending() {
        return this.orderDescending;
    }

    public void setOrderDescending(boolean orderDescending) {
        this.orderDescending = orderDescending;
    }
}

