/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.view;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public final class JstlFunctions {
    private static final String SETTING_PARAMS_PROLOG = "Setting params ";
    private static final String PROPERTY_SETTING_EXC_PROLOG = "Could not set property ";
    private static final String VALUES_FINDER_CLASS_EXC_PROLOG = "Could not find valuesFinder class ";
    private static final Logger LOG = LogManager.getLogger(JstlFunctions.class);
    private static KcAttachmentService KC_ATTACHMENT_SERVICE;
    private static ConfigurationService CONFIGURATION_SERVICE;
    private static ParameterService PARAMETER_SERVICE;

    private JstlFunctions() {
    }

    public static <T> List<T> copy(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static boolean isProfileActive(String profile) {
        String profiles = JstlFunctions.getConfigurationService().getPropertyValueAsString("spring.profiles.active");
        return Stream.of(profiles.split(",")).filter(Objects::nonNull).map(String::trim).filter(StringUtils::isNotBlank).anyMatch(p -> p.equals(profile));
    }

    public static boolean getConfigValueAsBoolean(String key) {
        return JstlFunctions.getConfigurationService().getPropertyValueAsBoolean(key);
    }

    public static String getConfigValue(String key) {
        return JstlFunctions.getConfigurationService().getPropertyValueAsString(key);
    }

    public static boolean getParameterValueAsBoolean(String namespaceCode, String componentCode, String parameterName) {
        return JstlFunctions.getParameterService().getParameterValueAsBoolean(namespaceCode, componentCode, parameterName);
    }

    public static String getParameterValue(String namespaceCode, String componentCode, String parameterName, String defaultValue) {
        String parameterValue = JstlFunctions.getParameterService().getParameterValueAsString(namespaceCode, componentCode, parameterName);
        return StringUtils.isBlank((CharSequence)parameterValue) ? defaultValue : parameterValue;
    }

    public static List getOptionList(String valuesFinderClassName, Map params) {
        return JstlFunctions.setupValuesFinder(valuesFinderClassName, params).getKeyValues();
    }

    public static BigDecimal getBigDecimal(ScaleTwoDecimal scaleTwoDecimal) {
        return scaleTwoDecimal.bigDecimalValue();
    }

    public static String getIconPath(String type) {
        return JstlFunctions.getKcAttachmentService().getFileTypeIcon(type);
    }

    public static float getFloatValue(ScaleTwoDecimal scaleTwoDecimal) {
        return scaleTwoDecimal.floatValue();
    }

    private static KeyValuesFinder setupValuesFinder(String valuesFinderClassName, Map<String, Object> params) {
        KeyValuesFinder retval = JstlFunctions.getKeyFinder(valuesFinderClassName);
        if (LOG.isDebugEnabled()) {
            LOG.debug(SETTING_PARAMS_PROLOG + params);
        }
        JstlFunctions.addParametersToFinder(params, retval);
        return retval;
    }

    private static void addParametersToFinder(Map<String, Object> params, KeyValuesFinder finder) {
        if (finder != null && params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                try {
                    BeanUtils.setProperty((Object)finder, (String)entry.getKey(), (Object)entry.getValue());
                }
                catch (Exception e) {
                    JstlFunctions.warn(PROPERTY_SETTING_EXC_PROLOG + entry.getKey(), e);
                }
            }
        }
    }

    private static KeyValuesFinder getKeyFinder(String valuesFinderClassName) {
        KeyValuesFinder retval = null;
        try {
            retval = (KeyValuesFinder)Class.forName(valuesFinderClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            JstlFunctions.warn(VALUES_FINDER_CLASS_EXC_PROLOG + valuesFinderClassName, e);
        }
        return retval;
    }

    private static void warn(String message, Exception e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(message, (Throwable)e);
        }
    }

    public static KcAttachmentService getKcAttachmentService() {
        if (KC_ATTACHMENT_SERVICE == null) {
            KC_ATTACHMENT_SERVICE = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return KC_ATTACHMENT_SERVICE;
    }

    public static void setKcAttachmentService(KcAttachmentService KcAttachmentService2) {
        KC_ATTACHMENT_SERVICE = KcAttachmentService2;
    }

    public static ConfigurationService getConfigurationService() {
        if (CONFIGURATION_SERVICE == null) {
            CONFIGURATION_SERVICE = KcServiceLocator.getService(ConfigurationService.class);
        }
        return CONFIGURATION_SERVICE;
    }

    public static void setKcAttachmentService(ConfigurationService configurationService) {
        CONFIGURATION_SERVICE = configurationService;
    }

    public static ParameterService getParameterService() {
        if (PARAMETER_SERVICE == null) {
            PARAMETER_SERVICE = KcServiceLocator.getService(ParameterService.class);
        }
        return PARAMETER_SERVICE;
    }

    public static void setParameterService(ParameterService parameterService) {
        PARAMETER_SERVICE = parameterService;
    }
}

