/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.auth.AuthServicePushService;
import org.kuali.coeus.sys.framework.auth.CoreUserPushService;
import org.kuali.coeus.sys.framework.auth.CoreUsersPushStatus;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class AuthServiceBulkPushAction
extends KualiAction
implements BackLocationAction {
    private static final String PUSH_MESSAGE_KEY = "info.user.bulk.push.complete";
    private static final String AUTH_SERVICE_BULK_PUSH = "AuthServiceBulkPush";
    private transient CoreUserPushService authServicePushService;
    private transient GlobalVariableService globalVariableService;

    public ActionForward pushAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, AUTH_SERVICE_BULK_PUSH, "Are you sure you want to push all users to the auth service", "confirmationQuestion", "cancel", "");
        }
        if (AUTH_SERVICE_BULK_PUSH.equals(question)) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("0".equals(buttonClicked)) {
                CoreUsersPushStatus status = this.getAuthServicePushService().pushAllUsers();
                this.getGlobalVariableService().getMessageList().add(PUSH_MESSAGE_KEY, new String[]{Integer.toString(status.getNumberOfUsers()), Integer.toString(status.getNumberAdded()), Integer.toString(status.getNumberUpdated()), Integer.toString(status.getNumberSame()), Integer.toString(status.getNumberRemoved()), Integer.toString(status.getErrors().size())});
            } else {
                return this.returnToSender(request, mapping, (KualiForm)form);
            }
        }
        return mapping.findForward("basic");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public CoreUserPushService getAuthServicePushService() {
        if (this.authServicePushService == null) {
            this.authServicePushService = KcServiceLocator.getService(AuthServicePushService.class);
        }
        return this.authServicePushService;
    }

    public void setAuthServicePushService(CoreUserPushService authServicePushService) {
        this.authServicePushService = authServicePushService;
    }
}

