/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.impl.core.CoreServicesUtil;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service(value="coreGroupsService")
public class CoreGroupsServiceImpl
implements CoreGroupsService {
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="coreServicesUtil")
    private CoreServicesUtil coreServicesUtil;

    @Override
    public String getCategoriesApiUrl() {
        return this.configurationService.getPropertyValueAsString("core.categories.url") + "/";
    }

    @Override
    public String getGroupsApiUrl() {
        return this.configurationService.getPropertyValueAsString("core.groups.url") + "/";
    }

    @Override
    public List<GroupDto> getAllGroups() {
        return this.getCoreServicesUtil().getAll(this.getGroupsApiUrl(), Collections.emptyMap(), new ParameterizedTypeReference<List<GroupDto>>(){});
    }

    @Override
    public String getUnitNumberForGroup(GroupDto group) {
        return group.getFields().stream().filter(f -> StringUtils.equals((CharSequence)f.getId(), (CharSequence)"UNIT_NUMBER")).map(GroupDto.GroupFields::getValue).findFirst().orElse(null);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public CoreServicesUtil getCoreServicesUtil() {
        return this.coreServicesUtil;
    }

    public void setCoreServicesUtil(CoreServicesUtil coreServicesUtil) {
        this.coreServicesUtil = coreServicesUtil;
    }
}

