/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.impl.lock.KcPessimisticLockService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="kcPessimisticLockService")
public class KcPessimisticLockServiceImpl
implements KcPessimisticLockService {
    private static final Logger LOG = LogManager.getLogger(KcPessimisticLockServiceImpl.class);
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private static final int DEFAULT_EXPIRATION_AGE = 1440;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="pessimisticLockService")
    private PessimisticLockService pessimisticLockService;

    @Override
    @Transactional
    public void clearExpiredLocks() {
        long now = this.getCurrentTime();
        long expirationAgeMillis = this.getExpirationAgeMillis();
        Collection<PessimisticLock> locks = this.getAllLocks();
        for (PessimisticLock lock : locks) {
            long lockTime = lock.getGeneratedTimestamp().getTime();
            if (now - lockTime < expirationAgeMillis) continue;
            this.dataObjectService.delete((Object)lock);
        }
    }

    @Override
    public boolean isPessimisticLockNeeded(ProposalDevelopmentDocument document, Person user, boolean canEdit, String customLockDescriptor) {
        ArrayList<String> userOwnedLockDescriptors = new ArrayList<String>();
        HashMap otherOwnedLockDescriptors = new HashMap();
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (pessimisticLock.isOwnedByUser(user)) {
                userOwnedLockDescriptors.add(pessimisticLock.getLockDescriptor());
                continue;
            }
            if (!otherOwnedLockDescriptors.containsKey(pessimisticLock.getLockDescriptor())) {
                otherOwnedLockDescriptors.put(pessimisticLock.getLockDescriptor(), new HashSet());
            }
            String otherOwnerPrincipalId = pessimisticLock.getOwnedByUser().getPrincipalId();
            ((Set)otherOwnedLockDescriptors.get(pessimisticLock.getLockDescriptor())).add(otherOwnerPrincipalId);
        }
        if (userOwnedLockDescriptors.isEmpty() && otherOwnedLockDescriptors.isEmpty()) {
            return canEdit;
        }
        boolean userOwnsCustomLockDescriptor = userOwnedLockDescriptors.contains(customLockDescriptor);
        boolean otherOwnsCustomLockDescriptor = otherOwnedLockDescriptors.containsKey(customLockDescriptor);
        if (!userOwnsCustomLockDescriptor && !otherOwnsCustomLockDescriptor) {
            return canEdit;
        }
        return false;
    }

    protected Collection<PessimisticLock> getAllLocks() {
        return this.dataObjectService.findMatching(PessimisticLock.class, QueryByCriteria.Builder.create().build()).getResults();
    }

    protected long getCurrentTime() {
        return this.dateTimeService.getCurrentTimestamp().getTime();
    }

    protected long getExpirationAgeMillis() {
        return (long)this.getLockExpirationAge() * 60000L;
    }

    protected int getLockExpirationAge() {
        String timeoutStr = this.parameterService.getParameterValueAsString("KC-SYS", "All", "pessimisticLocking.expirationAge");
        if (timeoutStr != null) {
            return Integer.parseInt(timeoutStr);
        }
        LOG.warn("Parameter: pessimisticLocking.expirationAge not found. Using Default value: 1440");
        return 1440;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }
}

