/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.persistence;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.persistence.PersistenceVerificationService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataCommon;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.exception.ClassNotPersistableException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="persistenceVerificationService")
public class PersistenceVerificationServiceImpl
implements PersistenceVerificationService {
    private static final Logger LOG = LogManager.getLogger(PersistenceVerificationServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcPersistenceStructureService")
    private KcPersistenceStructureService kcPersistenceStructureService;
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="providerRegistry")
    private ProviderRegistry providerRegistry;

    @Override
    public MessageMap verifyRelationshipsForDelete(Object bo, Collection<Class<?>> ignoredRelationships) {
        if (bo == null) {
            throw new IllegalArgumentException("bo cannot be null");
        }
        if (ignoredRelationships == null) {
            throw new IllegalArgumentException("ignoredRelationships cannot be null");
        }
        MessageMap relation = new MessageMap();
        try {
            MessageMap ojb = this.verifyOjbRelationshipsForDelete(bo, ignoredRelationships);
            relation.merge(ojb);
        }
        catch (ClassNotPersistableException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        MessageMap dd = this.verifyDDRelationshipsForDelete(bo, ignoredRelationships);
        MessageMap krad = this.verifyKradDataRelationshipsForDelete(bo, ignoredRelationships);
        relation.merge(dd);
        relation.merge(krad);
        return relation;
    }

    @Override
    public MessageMap verifyRelationshipsForUpdate(Object bo, Collection<Class<?>> ignoredRelationships) {
        return this.verifyRelationshipsForUpsert(bo, ignoredRelationships);
    }

    @Override
    public MessageMap verifyRelationshipsForInsert(Object bo, Collection<Class<?>> ignoredRelationships) {
        return this.verifyRelationshipsForUpsert(bo, ignoredRelationships);
    }

    @Override
    public List<String> persistableFields(Class<?> boClazz) {
        if (boClazz == null) {
            throw new IllegalArgumentException("bo cannot be null");
        }
        List<String> jpaFields = this.getProviderRegistry().getMetadataProviders().stream().filter(provider -> provider.getMetadataForType(boClazz) != null).flatMap(provider -> provider.getMetadataForType(boClazz).getAttributes().stream()).map(MetadataCommon::getName).distinct().collect(Collectors.toList());
        if (!jpaFields.isEmpty()) {
            return jpaFields;
        }
        List<String> ojbFields = this.getKcPersistenceStructureService().listFieldNames(boClazz, true);
        return ojbFields;
    }

    @Override
    public List<String> pkFields(Class<?> boClazz) {
        if (boClazz == null) {
            throw new IllegalArgumentException("bo cannot be null");
        }
        List<String> jpaFields = this.getProviderRegistry().getMetadataProviders().stream().filter(provider -> provider.getMetadataForType(boClazz) != null).flatMap(provider -> provider.getMetadataForType(boClazz).getPrimaryKeyAttributeNames().stream()).distinct().collect(Collectors.toList());
        if (!jpaFields.isEmpty()) {
            return jpaFields;
        }
        List ojbFields = this.getKcPersistenceStructureService().getPrimaryKeys(boClazz);
        return ojbFields;
    }

    protected MessageMap verifyRelationshipsForUpsert(Object bo, Collection<Class<?>> ignoredRelationships) {
        if (bo == null) {
            throw new IllegalArgumentException("bo cannot be null");
        }
        if (ignoredRelationships == null) {
            throw new IllegalArgumentException("ignoredRelationships cannot be null");
        }
        MessageMap relation = new MessageMap();
        try {
            MessageMap ojb = this.verifyOjbRelationshipsForUpsert(bo, ignoredRelationships);
            relation.merge(ojb);
            relation.merge(ojb);
        }
        catch (ClassNotPersistableException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        MessageMap dd = this.verifyDDRelationshipsForUpsert(bo, ignoredRelationships);
        MessageMap krad = this.verifyKradDataRelationshipsForUpsert(bo, ignoredRelationships);
        relation.merge(dd);
        relation.merge(krad);
        return relation;
    }

    protected MessageMap verifyOjbRelationshipsForUpsert(Object bo, Collection<Class<?>> ignoredRelationships) {
        MessageMap errors = new MessageMap();
        List fields = this.getKcPersistenceStructureService().listFieldNames(bo.getClass());
        fields.forEach(field -> {
            Map relationships = this.getKcPersistenceStructureService().getRelationshipMetadata(bo.getClass(), (String)field);
            if (relationships != null) {
                relationships.entrySet().stream().filter(relationship -> !ignoredRelationships.contains(((org.kuali.rice.krad.bo.DataObjectRelationship)relationship.getValue()).getRelatedClass())).forEach(relationship -> {
                    Map<String, Object> criteria;
                    if (this.getProperty(bo, (String)field) != null && this.validCriteria(criteria = Collections.singletonMap((String)((org.kuali.rice.krad.bo.DataObjectRelationship)relationship.getValue()).getParentToChildReferences().get(field), this.getProperty(bo, (String)field))) && this.getBusinessObjectService().countMatching(((org.kuali.rice.krad.bo.DataObjectRelationship)relationship.getValue()).getRelatedClass(), criteria) == 0) {
                        errors.putError(((org.kuali.rice.krad.bo.DataObjectRelationship)relationship.getValue()).getParentAttributeName(), "error.existence", new String[]{this.getRelationshipDescriptor(((org.kuali.rice.krad.bo.DataObjectRelationship)relationship.getValue()).getRelatedClass())});
                    }
                });
            }
        });
        return errors;
    }

    protected MessageMap verifyDDRelationshipsForUpsert(Object bo, Collection<Class<?>> ignoredRelationships) {
        MessageMap errors = new MessageMap();
        if (this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(bo.getClass().getName()) == null) {
            return errors;
        }
        List ddRelationships = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(bo.getClass().getName()).getRelationships();
        ddRelationships.stream().filter(relationship -> !ignoredRelationships.contains(relationship.getTargetClass())).forEach(relationship -> {
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            for (PrimitiveAttributeDefinition attr2 : relationship.getPrimitiveAttributes()) {
                criteria.put(attr2.getTargetName(), this.getProperty(bo, attr2.getSourceName()));
            }
            try {
                if (this.validCriteria(criteria) && this.getBusinessObjectService().countMatching(relationship.getTargetClass(), criteria) == 0) {
                    relationship.getPrimitiveAttributes().forEach(attr -> errors.putError(attr.getSourceName(), "error.existence", new String[]{this.getRelationshipDescriptor(relationship.getTargetClass())}));
                }
            }
            catch (ClassNotPersistenceCapableException | ClassNotPersistableException e) {
                LOG.debug(bo.getClass().getName() + " has a relationship to a non-persistable class " + relationship.getSourceClass(), e);
            }
        });
        return errors;
    }

    protected MessageMap verifyKradDataRelationshipsForUpsert(Object bo, Collection<Class<?>> ignoredRelationships) {
        Collection kradDataRelationships = this.getProviderRegistry().getMetadataProviders().stream().filter(provider -> provider.getMetadataForType(bo.getClass()) != null).flatMap(provider -> provider.getMetadataForType(bo.getClass()).getRelationships().stream()).collect(Collectors.toList());
        MessageMap errors = new MessageMap();
        kradDataRelationships.stream().filter(relationship -> !ignoredRelationships.contains(relationship.getRelatedType())).forEach(relationship -> {
            Map<String, Object> criteria = relationship.getAttributeRelationships().stream().map(attr -> CollectionUtils.entry(attr.getChildAttributeName(), this.getProperty(bo, attr.getParentAttributeName()))).collect(CollectionUtils.nullSafeEntriesToMap());
            if (this.validCriteria(criteria) && this.getDataObjectService().findMatching(relationship.getRelatedType(), QueryByCriteria.Builder.andAttributes(criteria).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount() == 0) {
                relationship.getAttributeRelationships().forEach(rel -> errors.putError(rel.getParentAttributeName(), "error.existence", new String[]{this.getRelationshipDescriptor(relationship.getRelatedType())}));
            }
        });
        return errors;
    }

    protected MessageMap verifyOjbRelationshipsForDelete(Object bo, Collection<Class<?>> ignoredRelationships) {
        List<org.kuali.rice.krad.bo.DataObjectRelationship> ojbRelationships = this.getKcPersistenceStructureService().getRelationshipsTo(bo.getClass());
        MessageMap errors = new MessageMap();
        ojbRelationships.stream().filter(relationship -> !ignoredRelationships.contains(relationship.getParentClass())).forEach(relationship -> {
            Map<String, Object> criteria = relationship.getParentToChildReferences().entrySet().stream().map(entry -> CollectionUtils.entry((String)entry.getKey(), this.getProperty(bo, (String)entry.getValue()))).collect(CollectionUtils.nullSafeEntriesToMap());
            if (this.validCriteria(criteria) && this.getBusinessObjectService().countMatching(relationship.getParentClass(), criteria) > 0) {
                errors.putError("GLOBAL_ERRORS", "error.deletion.blocked", new String[]{this.getRelationshipDescriptor(relationship.getParentClass())});
            }
        });
        return errors;
    }

    protected boolean validCriteria(Map<String, Object> criteria) {
        return !criteria.isEmpty() && criteria.values().stream().noneMatch(val -> val == null || val instanceof String && StringUtils.isBlank((CharSequence)((String)val)));
    }

    protected MessageMap verifyDDRelationshipsForDelete(Object bo, Collection<Class<?>> ignoredRelationships) {
        Collection ddRelationships = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntries().values().stream().flatMap(entry -> entry.getRelationships().stream()).filter(relationship -> relationship.getTargetClass().equals(bo.getClass())).collect(Collectors.toList());
        MessageMap errors = new MessageMap();
        ddRelationships.stream().filter(relationship -> !ignoredRelationships.contains(relationship.getSourceClass())).forEach(relationship -> {
            Map<String, Object> criteria = relationship.getPrimitiveAttributes().stream().map(attr -> CollectionUtils.entry(attr.getSourceName(), this.getProperty(bo, attr.getTargetName()))).collect(CollectionUtils.nullSafeEntriesToMap());
            try {
                if (this.validCriteria(criteria) && this.areAllColumnsInCriteriaMapped(criteria.keySet(), relationship.getSourceClass()) && this.getBusinessObjectService().countMatching(relationship.getSourceClass(), criteria) > 0) {
                    errors.putError("GLOBAL_ERRORS", "error.deletion.blocked", new String[]{this.getRelationshipDescriptor(relationship.getSourceClass())});
                }
            }
            catch (ClassNotPersistenceCapableException | ClassNotPersistableException e) {
                LOG.debug(bo.getClass().getName() + " has a relationship to a non-persistable class " + relationship.getSourceClass(), e);
            }
        });
        return errors;
    }

    protected boolean areAllColumnsInCriteriaMapped(Set<String> keySet, Class<?> clazz) {
        return this.persistableFields(clazz).containsAll(keySet);
    }

    protected MessageMap verifyKradDataRelationshipsForDelete(Object bo, Collection<Class<?>> ignoredRelationships) {
        List kradDataRelationships = this.getProviderRegistry().getMetadataProviders().stream().flatMap(provider -> provider.provideMetadata().values().stream()).flatMap(entry -> entry.getRelationships().stream().filter(relationship -> relationship.getRelatedType().equals(bo.getClass())).map(relationship -> CollectionUtils.entry(entry.getType(), relationship))).collect(Collectors.toList());
        MessageMap errors = new MessageMap();
        kradDataRelationships.stream().filter(relationship -> !ignoredRelationships.contains(relationship.getKey())).forEach(relationship -> {
            Map<String, Object> criteria = ((DataObjectRelationship)relationship.getValue()).getAttributeRelationships().stream().map(attr -> CollectionUtils.entry(attr.getParentAttributeName(), this.getProperty(bo, attr.getChildAttributeName()))).collect(CollectionUtils.nullSafeEntriesToMap());
            if (this.validCriteria(criteria) && this.getDataObjectService().findMatching((Class)relationship.getKey(), QueryByCriteria.Builder.andAttributes(criteria).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount() > 0) {
                errors.putError("GLOBAL_ERRORS", "error.deletion.blocked", new String[]{this.getRelationshipDescriptor((Class)relationship.getKey())});
            }
        });
        return errors;
    }

    protected String getRelationshipDescriptor(Class clazz) {
        BusinessObjectEntry entry = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(clazz.getName());
        if (entry != null && StringUtils.isNotEmpty((CharSequence)entry.getObjectLabel())) {
            return entry.getObjectLabel();
        }
        return clazz.getSimpleName();
    }

    private Object getProperty(Object o, String prop) {
        try {
            return PropertyUtils.getProperty((Object)o, (String)prop);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KcPersistenceStructureService getKcPersistenceStructureService() {
        return this.kcPersistenceStructureService;
    }

    public void setKcPersistenceStructureService(KcPersistenceStructureService kcPersistenceStructureService) {
        this.kcPersistenceStructureService = kcPersistenceStructureService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected ProviderRegistry getProviderRegistry() {
        return this.providerRegistry;
    }

    public void setProviderRegistry(ProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }
}

