/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.validation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.coeus.sys.framework.validation.ErrorHandlingUtilService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="errorHandlingUtilService")
public class ErrorHandlingUtilServiceImpl
implements ErrorHandlingUtilService {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Override
    public Map<String, List<String>> extractErrorMessages(MessageMap messageMap) {
        return this.resolveErrorMessages(messageMap.getErrorMessages());
    }

    @Override
    public Map<String, List<String>> resolveErrorMessages(Map<String, List<ErrorMessage>> errorMap) {
        return errorMap.entrySet().stream().map(entry -> CollectionUtils.entry(((String)entry.getKey()).replaceFirst("^\\.", ""), ((List)entry.getValue()).stream().map(this::resolveErrorMessage).collect(Collectors.toList()))).collect(CollectionUtils.entriesToMap());
    }

    @Override
    public String resolveErrorMessage(ErrorMessage errorMessage) {
        return this.resolveErrorKey(errorMessage.getErrorKey(), errorMessage.getMessageParameters());
    }

    @Override
    public String resolveErrorKey(String errorKey, String ... params) {
        String messageText = this.configurationService.getPropertyValueAsString(errorKey);
        for (int i = 0; i < params.length; ++i) {
            messageText = StringUtils.replace((String)messageText, (String)("{" + i + "}"), (String)params[i]);
        }
        return messageText;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

