/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcDocumentRejectionService")
public class KcDocumentRejectionServiceImpl
implements KcDocumentRejectionService {
    private static final Logger LOG = LogManager.getLogger(KcDocumentRejectionServiceImpl.class);
    @Autowired
    @Qualifier(value="routeHeaderService")
    private RouteHeaderService routeHeaderService;
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="kewWorkflowDocumentService")
    private WorkflowDocumentService workflowDocumentService;

    @Override
    public void reject(WorkflowDocument document, String reason, String principalId, String appDocStatus) {
        this.reject(document, reason, principalId, appDocStatus, this.getWorkflowInitialNodeName(document.getDocumentTypeName()));
    }

    @Override
    public void reject(WorkflowDocument document, String reason, String principalId, String appDocStatus, String nodeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Returning document %s to node %s as %s with reason '%s'", document, nodeName, principalId, reason));
        }
        document.returnToPreviousNode(reason, nodeName);
        try {
            DocumentRouteHeaderValue routeHeader = this.routeHeaderService.getRouteHeader(document.getDocumentId());
            routeHeader.markDocumentSaved();
            this.routeHeaderService.saveRouteHeader(routeHeader);
        }
        catch (InvalidActionTakenException e) {
            throw new RuntimeException(e);
        }
        if (appDocStatus != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Setting application document status of document %s to %s", document.getDocumentId(), appDocStatus));
            }
            document.setApplicationDocumentStatus(appDocStatus);
        }
    }

    @Override
    public boolean isDocumentOnInitialNode(WorkflowDocument document) {
        boolean ret = false;
        if (document != null) {
            ret = this.isDocumentOnNode(document.getDocumentId(), this.getWorkflowInitialNodeName(document.getDocumentTypeName()));
        }
        return ret;
    }

    protected boolean isDocumentOnNode(String documentNumber, String nodeName) {
        if (StringUtils.isNotBlank((CharSequence)documentNumber) && StringUtils.isNotBlank((CharSequence)nodeName)) {
            List currentRouteNodeNames = this.workflowDocumentService.getActiveRouteNodeNames(documentNumber);
            return currentRouteNodeNames.contains(nodeName);
        }
        return false;
    }

    @Override
    public String getWorkflowInitialNodeName(String docTypeName) {
        RoutePath path = this.documentTypeService.getRoutePathForDocumentTypeName(docTypeName);
        return path.getPrimaryProcess().getInitialRouteNode().getName();
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

