/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.service.impl;

import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class AwardBudgetFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            AwardBudgetDocument budgetDocument = (AwardBudgetDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, budgetDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        AwardBudgetDocument budgetDocument = (AwardBudgetDocument)document;
        AwardBudgetExt budget = budgetDocument.getBudget();
        this.addBudgetFacts(factsBuilder, budget);
    }

    private void addBudgetFacts(Facts.Builder factsBuilder, Budget budget) {
        this.addObjectMembersAsFacts(factsBuilder, budget, "KC-AWARD-BUDGET-CONTEXT", "KC-AB");
        factsBuilder.addFact("AwardBudgetExt", (Object)budget);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

