/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.HashMap;
import org.kuali.coeus.common.framework.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardCostShareRule;
import org.kuali.kra.award.commitments.AwardCostShareRuleEvent;
import org.kuali.kra.bo.CostShareType;

public class AwardCostShareRuleImpl
extends CostShareRuleResearchDocumentBase
implements AwardCostShareRule {
    private AwardCostShare awardCostShare;
    private String fieldStarter = "";
    private AwardBudgetService awardBudgetService;
    public static final String AWARD_COST_SHARE_FIELD = "costShareFormHelper.newAwardCostShare.source";

    @Override
    public boolean processCostShareBusinessRules(AwardCostShareRuleEvent awardCostShareRuleEvent, int i) {
        this.fieldStarter = "document.awardList[0].awardCostShares[" + i + "]";
        this.awardCostShare = awardCostShareRuleEvent.getCostShareForValidation();
        return this.processCommonValidations(this.awardCostShare);
    }

    public boolean processAddCostShareBusinessRules(AwardCostShareRuleEvent awardCostShareRuleEvent) {
        this.awardCostShare = awardCostShareRuleEvent.getCostShareForValidation();
        this.fieldStarter = "costShareFormHelper.newAwardCostShare";
        boolean isValid = this.processCommonValidations(this.awardCostShare);
        isValid &= this.validatePercentage(this.awardCostShare.getCostSharePercentage());
        isValid &= this.validateCostShareType(this.awardCostShare.getCostShareTypeCode());
        isValid &= this.getAwardBudgetService().isValidSourceAccountCostShareType("E", this.awardCostShare, awardCostShareRuleEvent.getFieldName());
        isValid &= this.validateCommitmentAmount(this.awardCostShare.getCommitmentAmount());
        return isValid &= this.validateCostShareMet(this.awardCostShare.getCostShareMet());
    }

    public boolean processCommonValidations(AwardCostShare awardCostShare) {
        boolean validSourceAndDestination = this.validateCostShareSourceAndDestinationForEquality(awardCostShare);
        boolean validFiscalYearRange = this.validateCostShareFiscalYearRange(awardCostShare);
        boolean validUnit = this.validateUnit(awardCostShare.getUnitNumber(), this.fieldStarter + ".unitNumber");
        boolean validSourceAccountCostShareType = this.getAwardBudgetService().isValidSourceAccountCostShareType("E", awardCostShare, AWARD_COST_SHARE_FIELD);
        return validSourceAndDestination && validFiscalYearRange && validUnit && validSourceAccountCostShareType;
    }

    public boolean validateCostShareSourceAndDestinationForEquality(AwardCostShare awardCostShare) {
        boolean valid = true;
        if (awardCostShare.getSource() != null && awardCostShare.getDestination() != null && awardCostShare.getSource().equals(awardCostShare.getDestination())) {
            valid = false;
            this.reportError(this.fieldStarter + ".source", "error.awardCostShare.source.destination", new String[0]);
        }
        return valid;
    }

    public boolean validateCostShareFiscalYearRange(AwardCostShare awardCostShare) {
        String projectPeriodField = this.fieldStarter + ".projectPeriod";
        return this.validateProjectPeriod(awardCostShare.getProjectPeriod(), projectPeriodField);
    }

    private boolean validatePercentage(ScaleTwoDecimal percentage) {
        boolean isValid = true;
        if (percentage != null && percentage.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError(this.fieldStarter + ".costSharePercentage", "error.awardCostShare.percentage.range", new String[0]);
        }
        return isValid;
    }

    private boolean validateCostShareType(Integer costShareTypeCode) {
        boolean isValid = true;
        String costShareTypeCodeField = this.fieldStarter + ".costShareTypeCode";
        if (costShareTypeCode != null) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("costShareTypeCode", costShareTypeCode);
            if (this.getBusinessObjectService().countMatching(CostShareType.class, fieldValues) != 1) {
                isValid = false;
                this.reportError(costShareTypeCodeField, "error.awardCostShare.costShareTypeCode.invalid", costShareTypeCode.toString());
            }
        }
        return isValid;
    }

    private boolean validateCommitmentAmount(ScaleTwoDecimal commitmentAmount) {
        boolean isValid = true;
        String commitmentAmountField = this.fieldStarter + ".commitmentAmount";
        if (commitmentAmount == null) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.awardCostShare.commitmentAmount.required", new String[0]);
        } else if (commitmentAmount.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.awardCostShare.commitmentAmount.invalid", commitmentAmount.toString());
        }
        return isValid;
    }

    private boolean validateCostShareMet(ScaleTwoDecimal costShareMet) {
        boolean isValid = true;
        if (costShareMet != null && costShareMet.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError(this.fieldStarter + ".costShareMet", "error.awardCostShare.costShareMet.invalid", costShareMet.toString());
        }
        return isValid;
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }
}

