/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.AwardFandaRateService;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardFandaRateServiceImpl
implements AwardFandaRateService {
    public static final int FOUR_DIGIT_YEAR_LENGTH = 4;
    protected static final String F_AND_A_RATE_CLASS_TYPE_CODE = "O";
    protected BusinessObjectService businessObjectService;
    private FiscalYearMonthService fiscalYearMonthService;

    @Override
    public List<String> getStartAndEndDatesBasedOnFiscalYear(String fiscalYear) {
        ArrayList<String> listDates = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)fiscalYear) && fiscalYear.length() == 4) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            Integer fy = Integer.parseInt(fiscalYear);
            listDates.add(dateFormat.format(new Date(this.getFiscalYearMonthService().getFiscalYearStartDate(fy).getTimeInMillis())));
            listDates.add(dateFormat.format(new Date(this.getFiscalYearMonthService().getFiscalYearEndDate(fy).getTimeInMillis())));
        }
        return listDates;
    }

    @Override
    public List<ValidRates> getValidRates(AwardFandaRate awardFandaRate) {
        if (ObjectUtils.isNull((Object)awardFandaRate)) {
            return new ArrayList<ValidRates>();
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (awardFandaRate.getOnCampusFlag().equalsIgnoreCase("N")) {
            criteria.put("onCampusRate", awardFandaRate.getApplicableFandaRate());
        } else {
            criteria.put("offCampusRate", awardFandaRate.getApplicableFandaRate());
        }
        criteria.put("rateClassType", F_AND_A_RATE_CLASS_TYPE_CODE);
        ArrayList<ValidRates> rates = new ArrayList<ValidRates>(this.businessObjectService.findMatching(ValidRates.class, criteria));
        return rates;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }
}

