/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.rest.SearchResults;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.util.OjbCollectionAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AwardDaoOjb
extends LookupDaoOjb
implements OjbCollectionAware,
AwardDao {
    private static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String AWARD_BUDGET_STATUS_CODE = "awardBudgetStatusCode";
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public String getAwardNumber(Long awardId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("awardId", (Object)awardId);
        ReportQueryByCriteria q = QueryFactory.newReportQuery(Award.class, (Criteria)crit);
        q.setAttributes(new String[]{"awardNumber"});
        Iterator resultsIter = this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q);
        if (!resultsIter.hasNext()) {
            return null;
        }
        String awardNumber = (String)resultsIter.next();
        while (resultsIter.hasNext()) {
            resultsIter.next();
        }
        return awardNumber;
    }

    @Override
    public Collection<Award> retrieveAwardsByCriteria(Map<String, Object> fieldValues) {
        Criteria crit = new Criteria();
        fieldValues.entrySet().forEach(entry -> crit.addEqualTo((String)entry.getKey(), entry.getValue()));
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(Award.class);
        if (searchResultsLimit != null) {
            LookupUtils.applySearchResultsLimit(Award.class, (Criteria)crit, (DatabasePlatform)this.getDbPlatform());
        }
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(Award.class, (Criteria)crit));
    }

    @Override
    public SearchResults<Award> retrieveActiveAwardsByCriteria(Map<String, Object> fieldValues, Date updatedSince, Integer page, Integer numberPerPage) {
        fieldValues.put("awardSequenceStatus", VersionStatus.ACTIVE.toString());
        return this.retrieveAwardsByCriteria(fieldValues, updatedSince, page, numberPerPage);
    }

    @Override
    public SearchResults<Award> retrieveAwardsByCriteria(Map<String, Object> fieldValues, Date updatedSince, Integer page, Integer numberPerPage) {
        SearchResults<Award> result = new SearchResults<Award>();
        Criteria origCrit = this.getCollectionCriteriaFromMap((BusinessObject)new Award(), fieldValues);
        Criteria crit = new Criteria();
        if (updatedSince != null) {
            crit.addGreaterOrEqualThan((Object)UPDATE_TIMESTAMP, (Object)updatedSince);
        }
        crit.addAndCriteria(origCrit);
        crit.addOrderByDescending("awardId");
        QueryByCriteria newCrit = QueryFactory.newQuery(Award.class, (Criteria)crit);
        if (page != null && numberPerPage != -1) {
            result.setTotalResults(this.getPersistenceBrokerTemplate().getCount((Query)newCrit));
            newCrit.setStartAtIndex((page - 1) * numberPerPage);
            newCrit.setEndAtIndex(page * numberPerPage);
        }
        result.setResults(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)newCrit));
        if (page == null) {
            result.setTotalResults(result.getResults().size());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Integer> getAwardSequenceNumbers(String awardNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Award getAward(Long awardId) {
        return (Award)this.getBusinessObjectService().findBySinglePrimaryKey(Award.class, (Object)awardId);
    }

    @Override
    public List<Award> getAwardByAwardNumber(String awardNumber, boolean activeVersionOnly) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("awardNumber", awardNumber);
        if (activeVersionOnly) {
            criteria.put("awardSequenceStatus", VersionStatus.ACTIVE.toString());
        }
        return (List)this.getBusinessObjectService().findMatching(Award.class, criteria);
    }

    @Override
    public List<Award> getAwardByAwardHierarchy(String awardFamily) {
        QueryByCriteria queryCriteria = this.getQueryForAwardHierarchyByAwardFamily(awardFamily);
        return new ArrayList<Award>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryCriteria));
    }

    QueryByCriteria getQueryForAwardHierarchyByAwardFamily(String awardFamily) {
        Criteria crit = new Criteria();
        crit.addLike((Object)"awardNumber", (Object)(awardFamily + "-%"));
        QueryByCriteria queryCrit = QueryFactory.newQuery(Award.class, (Criteria)crit);
        return queryCrit;
    }

    @Override
    public AwardBudgetExt getAwardBudget(String budgetId) {
        return (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budgetId);
    }

    @Override
    public List<AwardBudgetExt> getAwardBudgetByStatusCode(Integer code) {
        HashMap<String, Integer> criteria = new HashMap<String, Integer>();
        criteria.put(AWARD_BUDGET_STATUS_CODE, code);
        return (List)this.getBusinessObjectService().findMatching(AwardBudgetExt.class, criteria);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

