/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notification;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.notification.AwardReportTrackingNotificationRenderer;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;

public class AwardReportTrackingDigestNotificationRenderer
extends NotificationRendererBase {
    private static final long serialVersionUID = -4990706022002417957L;
    private static final String HEADER_FORMAT_STRING = "<h3>%s</h3>";
    private static final String OVERDUE_HEADER = "OVERDUE";
    private static final String DUE_HEADER = "DUE";
    private static final String PI_NAME_REPLACEMENT_PARAM = "{PI_NAME}";
    private static final String UNIT_NAME_REPLACEMENT_PARAM = "{LEAD_UNIT_NAME}";
    private static final String LIST_DELIMITER = ", ";
    private static final Pattern DIGEST_TABLE_PATTERN = Pattern.compile("(\\{BEGIN_DIGEST_TABLE}(.*)\\{END_DIGEST_TABLE})");
    private LocalDate comparisonDate = LocalDate.now();
    private boolean includeDue = true;
    private boolean includeOverdue = true;
    private Collection<ReportTracking> digestReports = new ArrayList<ReportTracking>();

    @Override
    public String render(String text) {
        String renderedText = this.replaceSection(text, DIGEST_TABLE_PATTERN, digestTableTemplate -> this.digestReports.stream().collect(Collectors.groupingBy(this::isOverdue, () -> new TreeMap(Comparator.reverseOrder()), Collectors.toList())).entrySet().stream().map(e -> this.renderDigestTable((Boolean)e.getKey(), (List)e.getValue(), (String)digestTableTemplate)).collect(Collectors.joining()));
        return super.render(renderedText);
    }

    protected String replaceSection(String inputText, Pattern repeatPattern, Function<String, String> replaceFunction) {
        Matcher matcher = repeatPattern.matcher(inputText);
        if (matcher.find()) {
            return inputText.replace(matcher.group(1), replaceFunction.apply(matcher.group(2)));
        }
        return inputText;
    }

    protected String renderDigestTable(boolean isOverdue, List<ReportTracking> reports, String template) {
        String header = String.format(HEADER_FORMAT_STRING, isOverdue ? OVERDUE_HEADER : DUE_HEADER);
        if (isOverdue && this.includeOverdue || !isOverdue && this.includeDue) {
            reports.sort(Comparator.comparing(ReportTracking::getPiName).thenComparing(ReportTracking::getDueDate).thenComparing(ReportTracking::getAwardNumber).thenComparing(ReportTracking::getReportClassCode).thenComparing(ReportTracking::getReportCode));
            return header + new AwardReportTrackingNotificationRenderer(reports).render(template);
        }
        return "";
    }

    protected boolean isOverdue(ReportTracking reportTracking) {
        return reportTracking.getDueDate() != null && reportTracking.getDueDate().toLocalDate().isBefore(this.comparisonDate);
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        Map<String, String> params = super.getDefaultReplacementParameters();
        if (CollectionUtils.isNotEmpty(this.digestReports)) {
            params.put(PI_NAME_REPLACEMENT_PARAM, this.getAwardReplacementParamList(Award::getPrincipalInvestigatorName));
            params.put(UNIT_NAME_REPLACEMENT_PARAM, this.getAwardReplacementParamList(Award::getLeadUnitName));
        }
        return params;
    }

    protected String getAwardReplacementParamList(Function<Award, String> awardFunction) {
        return this.makeListGrammaticallyCorrect(this.digestReports.stream().map(ReportTracking::getAward).map(awardFunction).distinct().sorted().collect(Collectors.joining(LIST_DELIMITER)));
    }

    protected String makeListGrammaticallyCorrect(String delimitedList) {
        if (StringUtils.isBlank((CharSequence)delimitedList)) {
            return "";
        }
        int numCommas = StringUtils.countMatches((CharSequence)delimitedList, (CharSequence)LIST_DELIMITER);
        if (numCommas == 1) {
            delimitedList = ((String)delimitedList).replace(LIST_DELIMITER, " and ");
        } else if (numCommas > 1) {
            int lastCommaIndex = ((String)delimitedList).lastIndexOf(LIST_DELIMITER);
            delimitedList = ((String)delimitedList).substring(0, lastCommaIndex) + ", and " + ((String)delimitedList).substring(lastCommaIndex + 2);
        }
        return delimitedList;
    }

    public void setComparisonDate(LocalDate comparisonDate) {
        this.comparisonDate = comparisonDate;
    }

    public void setIncludeDue(boolean includeDue) {
        this.includeDue = includeDue;
    }

    public void setIncludeOverdue(boolean includeOverdue) {
        this.includeOverdue = includeOverdue;
    }

    public void setDigestReports(Collection<ReportTracking> digestReports) {
        this.digestReports = digestReports;
    }
}

