/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.rules;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.rice.krad.datadictionary.validation.constraint.AnyCharacterPatternConstraint;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectAttachmentAddRuleImpl {
    private static final String EXCON_PROJECT_ATTACHMENT_ERROR_KEY = "exconProjectAttachmentsBean.newAttachment";
    private static final String ERROR_EXCON_PROJECT_ATTACHMENT_TYPE_IS_REQUIRED = "error.exconProjectAttachment.attachmentTypeIsRequired";
    private static final String ERROR_EXCON_PROJECT_ATTACHMENT_FILE_IS_REQUIRED = "error.exconProjectAttachment.attachmentFileIsRequired";
    private static final String ERROR_ATTACHMENT_FILE_INVALID_FORMAT = "error.format.org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern.allowWhitespace";

    public boolean processAddExconProjectAttachmentBusinessRules(ExconProject exconProject, ExconProjectAttachment newAttachment) {
        boolean valid = this.checkAttachmentTypeIsValid(newAttachment);
        return valid &= this.checkAttachmentFileIsValid(newAttachment);
    }

    public boolean checkAttachmentTypeIsValid(ExconProjectAttachment newAttachment) {
        if (newAttachment.getTypeCode() == null) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_ATTACHMENT_ERROR_KEY, ERROR_EXCON_PROJECT_ATTACHMENT_TYPE_IS_REQUIRED, new String[0]);
            return false;
        }
        return true;
    }

    public boolean checkAttachmentFileIsValid(ExconProjectAttachment newAttachment) {
        FormFile newFile = newAttachment.getNewFile();
        String filename = AttachmentFile.createFromFormFile(newFile).getName();
        if (newFile == null || StringUtils.isEmpty((CharSequence)filename)) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_ATTACHMENT_ERROR_KEY, ERROR_EXCON_PROJECT_ATTACHMENT_FILE_IS_REQUIRED, new String[0]);
            return false;
        }
        AnyCharacterPatternConstraint constraint = new AnyCharacterPatternConstraint();
        constraint.setAllowWhitespace(true);
        if (!filename.matches(constraint.getValue())) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_ATTACHMENT_ERROR_KEY, ERROR_ATTACHMENT_FILE_INVALID_FORMAT, new String[]{"File Name (" + filename + ")"});
            return false;
        }
        return true;
    }
}

