/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="budgetExpenseLookupableHelperService")
@Transactional
@Scope(value="prototype")
public class BudgetExpenseLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final String KFS_ON_PARM_NMSPC_CD = "KC-AWARD";
    private static final String KFS_ON_PARM_DTL_TYP_CD = "Document";
    private static final String KFS_ON_PARM_NM = "FIN_SYSTEM_INTEGRATION_ON";
    private static final String KFS_ON_OFF_VALUE = "OFF";
    private static final String KFS_FIELD_NAME = "financialObjectCode";

    public List<Row> getRows() {
        List oldRows = super.getRows();
        String kfsOnParameterValue = this.getParameterService().getParameterValueAsString(KFS_ON_PARM_NMSPC_CD, KFS_ON_PARM_DTL_TYP_CD, KFS_ON_PARM_NM);
        ArrayList<Row> rows = new ArrayList<Row>();
        if (!StringUtils.equals((CharSequence)kfsOnParameterValue, (CharSequence)KFS_ON_OFF_VALUE)) {
            rows.addAll(oldRows);
        } else {
            for (Row oldRow : oldRows) {
                Row row = new Row();
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field oldField : oldRow.getFields()) {
                    if (StringUtils.equals((CharSequence)oldField.getPropertyName(), (CharSequence)KFS_FIELD_NAME)) continue;
                    fields.add(oldField);
                }
                row.setFields(fields);
                rows.add(row);
            }
        }
        return rows;
    }

    public List<Column> getColumns() {
        List oldColumns = super.getColumns();
        String kfsOnParameterValue = this.getParameterService().getParameterValueAsString(KFS_ON_PARM_NMSPC_CD, KFS_ON_PARM_DTL_TYP_CD, KFS_ON_PARM_NM);
        ArrayList<Column> columns = new ArrayList<Column>();
        if (!StringUtils.equals((CharSequence)kfsOnParameterValue, (CharSequence)KFS_ON_OFF_VALUE)) {
            columns.addAll(oldColumns);
        } else {
            for (Column oldColumn : oldColumns) {
                if (StringUtils.equals((CharSequence)oldColumn.getPropertyName(), (CharSequence)KFS_FIELD_NAME)) continue;
                columns.add(oldColumn);
            }
        }
        return columns;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        String budgetCategoryTypeCode = fieldValues.get("budgetCategoryTypeCode");
        fieldValues.remove("budgetCategoryTypeCode");
        String categoryTypeName = null;
        if (fieldValues.get("onOffCampusFlag").equalsIgnoreCase("Y")) {
            fieldValues.put("onOffCampusFlag", "N");
        } else if (fieldValues.get("onOffCampusFlag").equalsIgnoreCase("N")) {
            fieldValues.put("onOffCampusFlag", "F");
        }
        List searchResults = super.getSearchResults(fieldValues);
        List searchResultsReturn = CollectionUtils.createCorrectImplementationForCollection(searchResults);
        for (CostElement costElement : searchResults) {
            costElement.refreshReferenceObject("budgetCategory");
            if (!StringUtils.isBlank((CharSequence)budgetCategoryTypeCode) && !StringUtils.equalsIgnoreCase((CharSequence)costElement.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)budgetCategoryTypeCode)) continue;
            searchResultsReturn.add(costElement);
            if (categoryTypeName != null) continue;
            categoryTypeName = costElement.getBudgetCategory().getBudgetCategoryType().getDescription();
        }
        if (StringUtils.isNotBlank((CharSequence)budgetCategoryTypeCode)) {
            KNSGlobalVariables.getMessageList().add("budget.expense.lookup.message1", new String[0]);
        }
        return searchResultsReturn;
    }
}

