/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.sponsor;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.kra.external.service.KcDtoServiceBase;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class SponsorDtoService
extends KcDtoServiceBase<SponsorDTO, Sponsor> {
    private ParameterService parameterService;
    private KcDtoService<RolodexDTO, Rolodex> rolodexDtoService;

    @Override
    public SponsorDTO buildDto(Sponsor sponsor) {
        SponsorDTO result = new SponsorDTO();
        result.setSponsorCode(sponsor.getSponsorCode());
        result.setAcronym(sponsor.getAcronym());
        result.setSponsorName(sponsor.getSponsorName());
        result.setSponsorTypeCode(sponsor.getSponsorTypeCode());
        if (sponsor.getSponsorType() != null) {
            result.setSponsorTypeDescription(sponsor.getSponsorType().getDescription());
        }
        result.setCustomerTypeCode(sponsor.getCustomerTypeCode());
        result.setCustomerNumber(sponsor.getCustomerNumber());
        result.setCageNumber(sponsor.getCageNumber());
        result.setDodacNumber(sponsor.getDodacNumber());
        result.setDunAndBradstreetNumber(sponsor.getDunAndBradstreetNumber());
        result.setDunsPlusFourNumber(sponsor.getDunsPlusFourNumber());
        result.setDunningCampaignId(sponsor.getDunningCampaignId());
        result.setState(sponsor.getState());
        result.setStateAgency(StringUtils.equals((CharSequence)sponsor.getSponsorTypeCode(), (CharSequence)this.getParameterService().getParameterValueAsString("KC-GEN", "All", "STATE_SPONSOR_TYPE")));
        result.setActive(sponsor.isActive());
        if (sponsor.getRolodex() != null) {
            result.setContactInformation(this.rolodexDtoService.buildDto(sponsor.getRolodex()));
        }
        return result;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public KcDtoService<RolodexDTO, Rolodex> getRolodexDtoService() {
        return this.rolodexDtoService;
    }

    public void setRolodexDtoService(KcDtoService<RolodexDTO, Rolodex> rolodexDtoService) {
        this.rolodexDtoService = rolodexDtoService;
    }
}

