/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalCfdaRuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalCfdaRule {
    public static final String CFDA_NUMBER = "cfdaNumber";

    @Override
    public boolean processCfdaRules(InstitutionalProposalCfdaRuleEvent institutionalProposalCfdaRuleEvent) {
        return this.validateCfdaNumber(institutionalProposalCfdaRuleEvent.getInstitutionalProposalForValidation());
    }

    private boolean validateCfdaNumber(InstitutionalProposal institutionalProposal) {
        boolean valid = true;
        for (int i = 0; i < institutionalProposal.getProposalCfdas().size(); ++i) {
            String cfdaNumber = institutionalProposal.getProposalCfdas().get(i).getCfdaNumber();
            if (StringUtils.isBlank((CharSequence)cfdaNumber)) {
                this.reportError(String.format("document.institutionalProposalList[0].proposalCfdas[%s].cfdaNumber", i), "cfda.required", new String[0]);
                continue;
            }
            if (this.isValidCfda(cfdaNumber) || GlobalVariables.getMessageMap().getMessages(String.format("document.institutionalProposalList[0].proposalCfdas[%s].cfdaNumber", i)) != null) continue;
            this.reportWarning(String.format("document.institutionalProposalList[0].proposalCfdas[%s].cfdaNumber", i), "error.format.cfda", cfdaNumber);
        }
        return valid;
    }

    public boolean isValidCfda(String cfdaNumber) {
        return StringUtils.isBlank((CharSequence)cfdaNumber) || cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?");
    }
}

