/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public class InstitutionalProposalAllUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    private UnitService unitService;
    private InstitutionalProposalService institutionalProposalService;
    private ParameterService parameterService;

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String proposalId = qualifiers.get("proposal");
        boolean ascendsHierarchy = this.shouldAscendHierarchy(qualifiers);
        if (StringUtils.isNotBlank((CharSequence)proposalId)) {
            InstitutionalProposal proposal = this.getInstitutionalProposalService().getInstitutionalProposal(proposalId);
            List admins = proposal.getProjectPersons().stream().flatMap(p -> this.getUnitsForPerson((InstitutionalProposalPerson)p, ascendsHierarchy).stream()).distinct().flatMap(u -> this.unitService.retrieveUnitAdministratorsByUnitNumber((String)u).stream()).collect(Collectors.toList());
            return this.getParameterService().getParameterValueAsBoolean("KC-IP", "All", "Include_Derived_Unit_Contacts") != false ? Stream.of(Optional.ofNullable(admins).orElse(Collections.emptyList()), Optional.ofNullable(proposal.getInstitutionalProposalUnitContacts()).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList()) : admins;
        }
        return new ArrayList();
    }

    protected Set<String> getUnitsForPerson(InstitutionalProposalPerson person, boolean ascendsHierarchy) {
        return person.getUnits().stream().map(InstitutionalProposalPersonUnit::getUnitNumber).distinct().flatMap(unitNumber -> {
            if (ascendsHierarchy) {
                return this.unitService.getUnitHierarchyForUnit((String)unitNumber).stream().map(Unit::getUnitNumber);
            }
            return Stream.of(unitNumber);
        }).collect(Collectors.toSet());
    }

    protected boolean shouldAscendHierarchy(Map<String, String> qualifiers) {
        String subunitsString = qualifiers.getOrDefault("subunits", "N");
        return "Y".equals(subunitsString) || "Yes".equals(subunitsString);
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

