/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.sys.framework.keyvalue.PrefixValuesFinder;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class NegotiationAssociationTypeValuesFinder
extends UifKeyValuesFinderBase {
    private static final String INACTIVE_IND = " (inactive)";
    private String currentValue;
    private boolean excludeInactive = false;
    private BusinessObjectService businessObjectService;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        ArrayList<ConcreteKeyValue> inactiveKeyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        Collection associations = this.getBusinessObjectService().findAllOrderBy(NegotiationAssociationType.class, "sortId", true);
        for (NegotiationAssociationType type : associations) {
            if (type.isActive()) {
                keyValues.add((KeyValue)new ConcreteKeyValue(type.getId().toString(), type.getDescription()));
                continue;
            }
            if (this.excludeInactive && !type.getId().toString().equals(this.currentValue)) continue;
            inactiveKeyValues.add(new ConcreteKeyValue(type.getId().toString(), type.getDescription().concat(INACTIVE_IND)));
        }
        keyValues.addAll(inactiveKeyValues);
        return keyValues;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public boolean isExcludeInactive() {
        return this.excludeInactive;
    }

    public void setExcludeInactive(boolean excludeInactive) {
        this.excludeInactive = excludeInactive;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

