/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.bo.NegotiationsGroupingBase;
import org.kuali.kra.negotiations.lookup.NegotiationDao;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.dao.DataIntegrityViolationException;
import org.springmodules.orm.ojb.OjbOperationException;

public class NegotiationDaoOjb
extends LookupDaoOjb
implements NegotiationDao {
    private static final String ASSOC_PREFIX = "associatedNegotiable";
    private static final String LINKED_BO_CLASS_ATTR = "negotiationAssociationType.linkedBoClass";
    private static final String ASSOCIATED_DOC_ID_ATTR = "associatedDocumentId";
    private static final String INVALID_COLUMN_NAME = "NaN";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String NEGOTIATION_AGE = "negotiationAge";
    private static final String SUBAWARD_SEQUENCE_STATUS = "subAwardSequenceStatus";
    private static final String SUBAWARD_ID = "subAwardId";
    private static final String SUBAWARD_CODE = "subAwardCode";
    private static Map<String, String> awardTransform = new HashMap<String, String>();
    private static Map<String, String> proposalTransform;
    private static Map<String, String> proposalLogTransform;
    private static Map<String, String> unassociatedTransform;
    private static Map<String, String> subAwardTransform;
    private NegotiationService negotiationService;

    @Override
    public Collection<Negotiation> getNegotiationResults(Map<String, String> fieldValues) {
        HashMap<String, String> associationDetails = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iter = fieldValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!StringUtils.startsWith((CharSequence)entry.getKey(), (CharSequence)ASSOC_PREFIX)) continue;
            iter.remove();
            if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            associationDetails.put(entry.getKey().replaceFirst("associatedNegotiable.", ""), entry.getValue());
        }
        Collection<Negotiation> result = new ArrayList<Negotiation>();
        if (!associationDetails.isEmpty()) {
            this.addListToList(result, this.getNegotiationsLinkedToAward(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToProposal(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToProposalLog(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsUnassociated(fieldValues, associationDetails));
            this.addListToList(result, this.getNegotiationsLinkedToSubAward(fieldValues, associationDetails));
        } else {
            result = this.findCollectionBySearchHelper(Negotiation.class, fieldValues, false, false);
        }
        String negotiationAge = fieldValues.get(NEGOTIATION_AGE);
        if (result != null && !result.isEmpty() && StringUtils.isNotBlank((CharSequence)negotiationAge)) {
            try {
                result = this.filterByNegotiationAge(negotiationAge, result);
            }
            catch (NumberFormatException e) {
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Invalid Numeric Input: " + negotiationAge});
                result = new ArrayList();
            }
        }
        return result;
    }

    private void addListToList(Collection<Negotiation> fullResultList, Collection<Negotiation> listToAdd) {
        if (fullResultList != null && listToAdd != null) {
            Integer max = LookupUtils.getSearchResultsLimit(Negotiation.class);
            if (max == null) {
                max = 500;
            }
            if (fullResultList.size() < max) {
                int fullResultListPlusListToAddSize = fullResultList.size() + listToAdd.size();
                if (fullResultListPlusListToAddSize <= max) {
                    fullResultList.addAll(listToAdd);
                } else {
                    int numberOfNewEntriesToAdd = max - fullResultList.size();
                    int counter = 1;
                    for (Negotiation neg : listToAdd) {
                        if (counter < numberOfNewEntriesToAdd) {
                            fullResultList.add(neg);
                        }
                        ++counter;
                    }
                }
            }
        }
    }

    private Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly, Object additionalCriteria) {
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        if (usePrimaryKeyValuesOnly) {
            return this.executeSearch(businessObjectClass, this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, formProps), unbounded);
        }
        Criteria crit = this.getCollectionCriteriaFromMap(businessObject, formProps);
        if (additionalCriteria != null && additionalCriteria instanceof Criteria) {
            crit.addAndCriteria((Criteria)additionalCriteria);
        }
        return this.executeSearch(businessObjectClass, crit, unbounded);
    }

    private BusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        BusinessObject businessObject;
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to LookupDaoOjb findCollectionBySearchHelper... method was null");
        }
        try {
            businessObject = (BusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    private Collection executeSearch(Class businessObjectClass, Criteria criteria, boolean unbounded) {
        ArrayList searchResults;
        Long matchingResultsCount = null;
        try {
            Integer searchResultsLimit = LookupUtils.getSearchResultsLimit((Class)businessObjectClass);
            if (!unbounded && searchResultsLimit != null) {
                matchingResultsCount = this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria));
                this.getDbPlatform().applyLimitSql(searchResultsLimit);
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = 0L;
            }
            searchResults = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria));
            ArrayList bos = new ArrayList();
            bos.addAll(searchResults);
            searchResults = bos;
        }
        catch (DataIntegrityViolationException | OjbOperationException e) {
            throw new RuntimeException("NegotiationDaoOjb encountered exception during executeSearch", e);
        }
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    protected Collection<Negotiation> getNegotiationsLinkedToAward(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, awardTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new Award(), values);
        Criteria activeAwardSubCriteria = new Criteria();
        activeAwardSubCriteria.addIn("awardSequenceStatus", Arrays.asList(VersionStatus.ACTIVE.toString(), VersionStatus.PENDING.toString()));
        ReportQueryByCriteria activeAwardIdsQuery = QueryFactory.newReportQuery(Award.class, (Criteria)activeAwardSubCriteria);
        activeAwardIdsQuery.setAttributes(new String[]{"max(awardId)"});
        activeAwardIdsQuery.addGroupBy("awardNumber");
        criteria.addIn((Object)"awardId", (Query)activeAwardIdsQuery);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(Award.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"awardNumber"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(LINKED_BO_CLASS_ATTR, (Object)Award.class.getSimpleName());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToProposal(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, proposalTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        values.put("proposalSequenceStatus", VersionStatus.ACTIVE.name());
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new InstitutionalProposal(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(InstitutionalProposal.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{PROPOSAL_NUMBER});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(LINKED_BO_CLASS_ATTR, (Object)InstitutionalProposal.class.getSimpleName());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToProposalLog(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, proposalLogTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ProposalLog(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ProposalLog.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{PROPOSAL_NUMBER});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(LINKED_BO_CLASS_ATTR, (Object)ProposalLog.class.getSimpleName());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsLinkedToSubAward(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, subAwardTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new SubAward(), values);
        Criteria activeSubAwardSubCriteria = new Criteria();
        List<String> versionStatuses = Arrays.asList(VersionStatus.PENDING.name(), VersionStatus.ACTIVE.name());
        activeSubAwardSubCriteria.addIn(SUBAWARD_SEQUENCE_STATUS, versionStatuses);
        ReportQueryByCriteria activeSubAwardIdsQuery = QueryFactory.newReportQuery(SubAward.class, (Criteria)activeSubAwardSubCriteria);
        activeSubAwardIdsQuery.setAttributes(new String[]{"max(subAwardId)"});
        activeSubAwardIdsQuery.addGroupBy(SUBAWARD_CODE);
        criteria.addIn((Object)SUBAWARD_ID, (Query)activeSubAwardIdsQuery);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(SubAward.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{SUBAWARD_ID});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        negotiationCrit.addEqualTo(LINKED_BO_CLASS_ATTR, (Object)SubAward.class.getSimpleName());
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Collection<Negotiation> getNegotiationsUnassociated(Map<String, String> negotiationValues, Map<String, String> associatedValues) {
        Map<String, String> values = this.transformMap(associatedValues, unassociatedTransform);
        if (values == null) {
            return new ArrayList<Negotiation>();
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new NegotiationUnassociatedDetail(), values);
        Criteria negotiationCrit = new Criteria();
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(NegotiationUnassociatedDetail.class, (Criteria)criteria);
        subQuery.setAttributes(new String[]{"negotiationUnassociatedDetailId"});
        negotiationCrit.addIn((Object)ASSOCIATED_DOC_ID_ATTR, (Query)subQuery);
        if (StringUtils.isNotBlank((CharSequence)negotiationValues.get("negotiationAssociationTypeId"))) {
            negotiationCrit.addEqualTo("negotiationAssociationTypeId", (Object)negotiationValues.get("negotiationAssociationTypeId"));
        } else {
            List noneAssocTypeIds = this.findCollectionBySearchHelper(NegotiationAssociationType.class, Map.of("linkedBoClass", "None"), true, false, null).stream().map(NegotiationsGroupingBase::getId).collect(Collectors.toList());
            negotiationCrit.addIn("negotiationAssociationTypeId", noneAssocTypeIds);
        }
        Collection result = this.findCollectionBySearchHelper(Negotiation.class, negotiationValues, false, false, negotiationCrit);
        return result;
    }

    protected Map<String, String> transformMap(Map<String, String> values, Map<String, String> transformKey) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            if (transformKey.get(entry.getKey()) != null) {
                result.put(transformKey.get(entry.getKey()), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        if (result.containsKey(INVALID_COLUMN_NAME)) {
            return null;
        }
        return result;
    }

    protected Collection<Negotiation> filterByNegotiationAge(String value, Collection<Negotiation> negotiations) {
        int lowValue = 0;
        int highValue = 0;
        boolean greaterThan = false;
        boolean lessThan = false;
        boolean between = false;
        if (value.contains(">")) {
            greaterThan = true;
            lowValue = Integer.parseInt(value.replace(">", ""));
        } else if (value.contains("<")) {
            lessThan = true;
            highValue = Integer.parseInt(value.replace("<", ""));
        } else if (value.contains("..")) {
            between = true;
            String[] values = value.split("\\.\\.");
            lowValue = Integer.parseInt(values[0]);
            highValue = Integer.parseInt(values[1]);
        } else {
            lowValue = Integer.parseInt(value);
        }
        Iterator<Negotiation> iter = negotiations.iterator();
        while (iter.hasNext()) {
            Negotiation negotiation = iter.next();
            if (greaterThan) {
                if (negotiation.getNegotiationAge() > (long)lowValue) continue;
                iter.remove();
                continue;
            }
            if (lessThan) {
                if (negotiation.getNegotiationAge() < (long)highValue) continue;
                iter.remove();
                continue;
            }
            if (between) {
                if (negotiation.getNegotiationAge() >= (long)lowValue && negotiation.getNegotiationAge() <= (long)highValue) continue;
                iter.remove();
                continue;
            }
            if (negotiation.getNegotiationAge() == (long)lowValue) continue;
            iter.remove();
        }
        return negotiations;
    }

    public NegotiationService getNegotiationService() {
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    static {
        awardTransform.put("sponsorName", "sponsor.sponsorName");
        awardTransform.put("piName", "projectPersons.fullName");
        awardTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        awardTransform.put("leadUnitNumber", "unitNumber");
        awardTransform.put("leadUnitName", "leadUnit.unitName");
        awardTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        proposalTransform = new HashMap<String, String>();
        proposalTransform.put("sponsorName", "sponsor.sponsorName");
        proposalTransform.put("piName", "projectPersons.fullName");
        proposalTransform.put("leadUnitNumber", "unitNumber");
        proposalTransform.put("leadUnitName", "leadUnit.unitName");
        proposalTransform.put("negotiableProposalTypeCode", "proposalTypeCode");
        proposalTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        proposalLogTransform = new HashMap<String, String>();
        proposalLogTransform.put("sponsorName", "sponsor.sponsorName");
        proposalLogTransform.put("leadUnitNumber", "leadUnit");
        proposalLogTransform.put("leadUnitName", "unit.unitName");
        proposalLogTransform.put("negotiableProposalTypeCode", "proposalTypeCode");
        proposalLogTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        unassociatedTransform = new HashMap<String, String>();
        unassociatedTransform.put("sponsorName", "sponsor.sponsorName");
        unassociatedTransform.put("piName", "piName");
        unassociatedTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        unassociatedTransform.put("leadUnitName", "leadUnit.unitName");
        unassociatedTransform.put("subAwardRequisitionerId", INVALID_COLUMN_NAME);
        subAwardTransform = new HashMap<String, String>();
        subAwardTransform.put("sponsorName", INVALID_COLUMN_NAME);
        subAwardTransform.put("sponsorCode", INVALID_COLUMN_NAME);
        subAwardTransform.put("piName", INVALID_COLUMN_NAME);
        subAwardTransform.put("negotiableProposalTypeCode", INVALID_COLUMN_NAME);
        subAwardTransform.put("leadUnitNumber", "unitNumber");
        subAwardTransform.put("leadUnitName", "leadUnit.unitName");
        subAwardTransform.put("subAwardRequisitionerId", "requisitionerId");
    }
}

