/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.framework.attachment.AttachmentDocumentStatus;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAttachment;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubAwardAttachmentFormBean
implements Serializable {
    private static final long serialVersionUID = 4184903707661244083L;
    private final SubAwardForm form;
    private SubAwardAttachment newAttachment;
    private boolean disableAttachmentRemovalIndicator = false;

    public SubAwardAttachmentFormBean(SubAwardForm form) {
        this.form = form;
    }

    public SubAwardAttachment getNewAttachment() {
        if (this.newAttachment == null) {
            this.initAttachment();
        }
        return this.newAttachment;
    }

    private void initAttachment() {
        this.setNewAttachment(new SubAwardAttachment(this.getSubAward()));
    }

    public void setNewAttachment(SubAwardAttachment newAttachment) {
        this.newAttachment = newAttachment;
    }

    public boolean isDisableAttachmentRemovalIndicator() {
        return this.disableAttachmentRemovalIndicator;
    }

    public void setDisableAttachmentRemovalIndicator(boolean disableAttachmentRemovalIndicator) {
        this.disableAttachmentRemovalIndicator = disableAttachmentRemovalIndicator;
    }

    public SubAwardForm getForm() {
        return this.form;
    }

    public SubAward getSubAward() {
        if (this.form.getSubAwardDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.form.getSubAwardDocument().getSubAward() == null) {
            throw new IllegalArgumentException("the subAward is null");
        }
        return this.form.getSubAwardDocument().getSubAward();
    }

    public void addNewSubAwardAttachment() {
        this.refreshAttachmentReferences(Collections.singletonList(this.getNewAttachment()));
        this.syncNewFiles(Collections.singletonList(this.getNewAttachment()));
        this.assignDocumentId(Collections.singletonList(this.getNewAttachment()), this.createTypeToMaxDocNumber(this.getSubAward().getSubAwardAttachments()));
        this.newAttachment.setSubAwardId(this.getSubAward().getSubAwardId());
        this.newAttachment.setDocumentStatusCode(AttachmentDocumentStatus.ACTIVE.getCode());
        this.getSubAward().addSubAwardAttachment(this.newAttachment);
        this.getBusinessObjectService().save((PersistableBusinessObject)this.newAttachment);
        this.initNewAttachment();
    }

    public SubAwardAttachment retrieveExistingAttachment(int attachmentNumber) {
        if (!SubAwardAttachmentFormBean.validIndexForList(attachmentNumber, this.getSubAward().getSubAwardAttachments())) {
            return null;
        }
        return this.getSubAward().getSubAwardAttachments().get(attachmentNumber);
    }

    private static boolean validIndexForList(int index, List<?> forList) {
        return forList != null && index >= 0 && index <= forList.size() - 1;
    }

    private void initNewAttachment() {
        this.setNewAttachment(new SubAwardAttachment(this.getSubAward()));
    }

    private Map<Integer, Integer> createTypeToMaxDocNumber(List<SubAwardAttachment> attachments) {
        HashMap<Integer, Integer> typeToDocNumber = new HashMap<Integer, Integer>();
        for (SubAwardAttachment attachment : attachments) {
            Integer curMax = (Integer)typeToDocNumber.get(attachment.getSubAwardAttachmentTypeCode());
            if (curMax != null && curMax >= attachment.getDocumentId()) continue;
            typeToDocNumber.put(attachment.getSubAwardAttachmentTypeCode(), attachment.getDocumentId());
        }
        return typeToDocNumber;
    }

    private void assignDocumentId(List<SubAwardAttachment> attachments, Map<Integer, Integer> typeToDocNumber) {
        for (SubAwardAttachment attachment : attachments) {
            if (!attachment.isNew()) continue;
            Integer nextDocNumber = SubAwardAttachmentFormBean.createNextDocNumber(typeToDocNumber.get(attachment.getSubAwardAttachmentTypeCode()));
            attachment.setDocumentId(nextDocNumber);
        }
    }

    private static Integer createNextDocNumber(Integer docNumber) {
        return docNumber == null ? NumberUtils.INTEGER_ONE : Integer.valueOf(docNumber + 1);
    }

    private void refreshAttachmentReferences(List<SubAwardAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (SubAwardAttachment attachment : attachments) {
            attachment.refreshReferenceObject("typeAttachment");
        }
    }

    private void syncNewFiles(List<SubAwardAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (SubAwardAttachment attachment : attachments) {
            if (!this.getKcAttachmentService().doesNewFileExist(attachment.getNewFile())) continue;
            attachment.setFileName(attachment.getNewFile().getFileName());
            attachment.setContentType(attachment.getNewFile().getContentType());
            try {
                attachment.setDocument(attachment.getNewFile().getFileData());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private KcAttachmentService getKcAttachmentService() {
        return KcServiceLocator.getService(KcAttachmentService.class);
    }
}

