/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.cache.CacheManagerRegistry;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.springframework.beans.factory.NamedBean;
import org.springframework.cache.CacheManager;

public final class CacheManagerRegistryImpl
implements CacheManagerRegistry {
    private static final String GET_NAME = "getName";
    private static final Logger LOG = LogManager.getLogger(CacheManagerRegistryImpl.class);
    private static final String GET_NAME_MSG = "unable to get the getName method on the cache manager";
    private static final List<CacheManager> CACHE_MANAGERS = new CopyOnWriteArrayList<CacheManager>();
    private static final Map<String, CacheManager> CACHE_MANAGER_MAP = new ConcurrentHashMap<String, CacheManager>();

    public void setCacheManager(CacheManager c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        CACHE_MANAGERS.add(c);
        for (String cacheName : c.getCacheNames()) {
            CACHE_MANAGER_MAP.put(cacheName, c);
        }
    }

    public List<CacheManager> getCacheManagers() {
        return Collections.unmodifiableList(CACHE_MANAGERS);
    }

    public CacheManager getCacheManager(String name) {
        for (CacheManager cm : this.getCacheManagers()) {
            if (!name.equals(this.getCacheManagerName(cm))) continue;
            return cm;
        }
        return null;
    }

    public String getCacheManagerName(CacheManager cm) {
        if (cm instanceof NamedBean) {
            return ((NamedBean)cm).getBeanName();
        }
        Object v = "Unnamed CacheManager " + cm.hashCode();
        try {
            Method nameMethod = cm.getClass().getMethod(GET_NAME, new Class[0]);
            if (nameMethod != null && nameMethod.getReturnType() == String.class) {
                v = (String)nameMethod.invoke((Object)cm, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn(GET_NAME_MSG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.warn(GET_NAME_MSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn(GET_NAME_MSG, (Throwable)e);
        }
        return v;
    }

    public CacheManager getCacheManagerByCacheName(String cacheName) {
        CacheManager cm = CACHE_MANAGER_MAP.get(cacheName);
        if (cm != null) {
            return cm;
        }
        throw new RiceIllegalArgumentException("Cache not found : " + cacheName);
    }
}

