/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.resourceloader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderException;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;

public final class ResourceLoaderUtil {
    private static final Logger LOG = LogManager.getLogger(ResourceLoaderUtil.class);

    private ResourceLoaderUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Object createObject(String className, ClassLoader classLoader) {
        try {
            Class<?> theClass = Class.forName(className, true, classLoader);
            return ContextClassLoaderProxy.wrap(theClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            LOG.error("Error instantiating class '" + className + "' in classloader " + classLoader, (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            throw new ResourceLoaderException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceLoaderException((Throwable)e);
        }
    }
}

