/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.Truth;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final String MESSAGE_RESOURCES = "rice.struts.message.resources";
    private final PropertyHolder propertyHolder = new PropertyHolder();

    public ConfigurationServiceImpl() {
        String[] bundleNames;
        this.propertyHolder.getHeldProperties().putAll((Map<?, ?>)ConfigContext.getCurrentContextConfig().getProperties());
        String propertyConfig = (String)ConfigContext.getCurrentContextConfig().getProperties().get(MESSAGE_RESOURCES);
        propertyConfig = this.removeSpacesAround(propertyConfig);
        for (String bundleName : bundleNames = StringUtils.split((String)propertyConfig, (String)",")) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
            for (String key : bundle.keySet()) {
                String message = bundle.getString(key);
                this.propertyHolder.getHeldProperties().put(key, message);
            }
        }
    }

    public String getPropertyValueAsString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("invalid (null) key");
        }
        return this.propertyHolder.getProperty(key);
    }

    public boolean getPropertyValueAsBoolean(String key) {
        if (key == null) {
            throw new IllegalArgumentException("invalid (null) key");
        }
        String property = this.propertyHolder.getProperty(key);
        Boolean b = Truth.strToBooleanIgnoreCase((String)property);
        if (b == null) {
            return false;
        }
        return b;
    }

    public Map<String, String> getAllProperties() {
        return Collections.unmodifiableMap(this.propertyHolder.getHeldProperties());
    }

    private String removeSpacesAround(String csv) {
        if (csv == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String value : csv.split(",")) {
            if ("".equals(value.trim())) continue;
            result.append(value.trim());
            result.append(",");
        }
        int i = result.lastIndexOf(",");
        if (i != -1) {
            result.deleteCharAt(i);
        }
        return result.toString();
    }

    protected static class FilePropertySource
    implements PropertySource {
        private static final Logger LOG = LogManager.getLogger(FilePropertySource.class);
        private String fileName;
        private boolean allowOverrides;

        protected FilePropertySource() {
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAllowOverrides() {
            return this.allowOverrides;
        }

        public void setAllowOverrides(boolean allowOverrides) {
            this.allowOverrides = allowOverrides;
        }

        @Override
        public Properties loadProperties() {
            if (StringUtils.isBlank((String)this.getFileName())) {
                throw new IllegalStateException("invalid (blank) fileName");
            }
            Properties properties = new Properties();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(this.getFileName());
            if (url == null) {
                throw new RiceRuntimeException("unable to locate properties file '" + this.getFileName() + "'");
            }
            InputStream in = null;
            try {
                in = url.openStream();
                properties.load(in);
            }
            catch (IOException e) {
                throw new RiceRuntimeException("error loading from properties file '" + this.getFileName() + "'", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.error("caught exception closing InputStream: ", (Throwable)e);
                    }
                }
            }
            return properties;
        }
    }

    protected static class PropertyHolder {
        private static Logger LOG = LogManager.getLogger(PropertyHolder.class);
        Properties heldProperties = new Properties();

        public boolean isEmpty() {
            return this.heldProperties.isEmpty();
        }

        public boolean containsKey(String key) {
            this.validateKey(key);
            return this.heldProperties.containsKey(key);
        }

        public String getProperty(String key) {
            this.validateKey(key);
            return this.heldProperties.getProperty(key);
        }

        public void setProperty(String key, String value) {
            this.setProperty(null, key, value);
        }

        public void setProperty(PropertySource source, String key, String value) {
            this.validateKey(key);
            this.validateValue(value);
            if (this.containsKey(key)) {
                if (source != null && source instanceof FilePropertySource && ((FilePropertySource)source).isAllowOverrides()) {
                    LOG.info("Duplicate Key: Override is enabled [key=" + key + ", new value=" + value + ", old value=" + this.heldProperties.getProperty(key) + "]");
                } else {
                    throw new RiceRuntimeException("duplicate key '" + key + "'");
                }
            }
            this.heldProperties.setProperty(key, value);
        }

        public void clearProperty(String key) {
            this.validateKey(key);
            this.heldProperties.remove(key);
        }

        public void loadProperties(PropertySource source) {
            if (source == null) {
                throw new IllegalArgumentException("invalid (null) source");
            }
            Properties newProperties = source.loadProperties();
            for (String string : newProperties.keySet()) {
                this.setProperty(source, string, newProperties.getProperty(string));
            }
        }

        public void clearProperties() {
            this.heldProperties.clear();
        }

        public Iterator getKeys() {
            return this.heldProperties.keySet().iterator();
        }

        private void validateKey(String key) {
            if (key == null) {
                throw new IllegalArgumentException("invalid (null) key");
            }
        }

        private void validateValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("invalid (null) value");
            }
        }

        public Properties getHeldProperties() {
            return this.heldProperties;
        }

        public void setHeldProperties(Properties heldProperties) {
            this.heldProperties = heldProperties;
        }
    }

    protected static interface PropertySource {
        public Properties loadProperties();
    }
}

