/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleService;

class StyleUriResolver
implements URIResolver {
    private static final Logger LOG = LogManager.getLogger(StyleUriResolver.class);
    private final StyleService styleService;

    StyleUriResolver(StyleService styleService) {
        if (styleService == null) {
            throw new IllegalArgumentException("styleService cannot be null");
        }
        this.styleService = styleService;
    }

    @Override
    public Source resolve(String href, String base) {
        try {
            Style style = this.styleService.getStyle(href);
            return new StreamSource(new StringReader(style.getXmlContent()));
        }
        catch (Exception e) {
            LOG.error("Error ocurred getting style " + href, (Throwable)e);
            return null;
        }
    }
}

