/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.api.repository.RepositoryDataException;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeEntryDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeRuleEntry;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeSubAgendaEntry;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicContext;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.SubAgenda;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.framework.type.TermResolverTypeService;
import org.kuali.rice.krms.impl.provider.repository.LazyAction;
import org.kuali.rice.krms.impl.provider.repository.LazyProposition;
import org.kuali.rice.krms.impl.provider.repository.LazyRule;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.type.AgendaTypeServiceBase;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;
import org.springframework.util.CollectionUtils;

public class RepositoryToEngineTranslatorImpl
implements RepositoryToEngineTranslator {
    private RuleRepositoryService ruleRepositoryService;
    private TermRepositoryService termRepositoryService;
    private KrmsTypeResolver typeResolver;

    @Override
    public Context translateContextDefinition(ContextDefinition contextDefinition) {
        if (contextDefinition == null) {
            return null;
        }
        ArrayList<Agenda> agendas = new ArrayList<Agenda>();
        for (AgendaDefinition agendaDefinition : contextDefinition.getAgendas()) {
            Agenda agenda = this.translateAgendaDefinition(agendaDefinition);
            agendas.add(agenda);
        }
        List termResolverDefs = this.getTermRepositoryService().findTermResolversByNamespace(contextDefinition.getNamespace());
        ArrayList termResolvers = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)termResolverDefs)) {
            for (TermResolverDefinition termResolverDef : termResolverDefs) {
                TermResolver<?> termResolver;
                if (termResolverDef == null || (termResolver = this.translateTermResolver(termResolverDef)) == null) continue;
                termResolvers.add(termResolver);
            }
        }
        return new BasicContext(agendas, termResolvers);
    }

    private TermResolver<?> translateTermResolver(TermResolverDefinition termResolverDef) {
        if (termResolverDef == null) {
            throw new IllegalArgumentException("termResolverDef must not be null");
        }
        TermResolverTypeService termResolverTypeService = this.typeResolver.getTermResolverTypeService(termResolverDef);
        TermResolver termResolver = termResolverTypeService.loadTermResolver(termResolverDef);
        return termResolver;
    }

    @Override
    public Agenda translateAgendaDefinition(AgendaDefinition agendaDefinition) {
        Agenda result = null;
        if (StringUtils.isEmpty((String)agendaDefinition.getTypeId())) {
            result = AgendaTypeServiceBase.defaultAgendaTypeService.loadAgenda(agendaDefinition);
        } else {
            AgendaTypeService agendaTypeService = this.typeResolver.getAgendaTypeService(agendaDefinition);
            result = agendaTypeService.loadAgenda(agendaDefinition);
        }
        return result;
    }

    @Override
    public AgendaTree translateAgendaDefinitionToAgendaTree(AgendaDefinition agendaDefinition) {
        AgendaTreeDefinition agendaTreeDefinition = this.ruleRepositoryService.getAgendaTree(agendaDefinition.getId());
        return this.translateAgendaTreeDefinition(agendaTreeDefinition);
    }

    @Override
    public AgendaTree translateAgendaTreeDefinition(AgendaTreeDefinition agendaTreeDefinition) {
        ArrayList<String> ruleIds = new ArrayList<String>();
        ArrayList<String> subAgendaIds = new ArrayList<String>();
        for (AgendaTreeEntryDefinitionContract entryDefinition : agendaTreeDefinition.getEntries()) {
            if (entryDefinition instanceof AgendaTreeRuleEntry) {
                ruleIds.add(((AgendaTreeRuleEntry)entryDefinition).getRuleId());
                continue;
            }
            if (entryDefinition instanceof AgendaTreeSubAgendaEntry) {
                subAgendaIds.add(((AgendaTreeSubAgendaEntry)entryDefinition).getSubAgendaId());
                continue;
            }
            throw new IllegalStateException("Encountered invalid agenda tree entry definition class, did not understand type: " + entryDefinition);
        }
        Map<String, Rule> rules = this.loadRules(ruleIds);
        Map<String, SubAgenda> subAgendas = this.loadSubAgendas(subAgendaIds);
        ArrayList<BasicAgendaTreeEntry> entries = new ArrayList<BasicAgendaTreeEntry>();
        for (AgendaTreeEntryDefinitionContract entryDefinition : agendaTreeDefinition.getEntries()) {
            if (entryDefinition instanceof AgendaTreeRuleEntry) {
                Rule rule;
                AgendaTreeRuleEntry ruleEntry = (AgendaTreeRuleEntry)entryDefinition;
                AgendaTree ifTrue = null;
                AgendaTree ifFalse = null;
                if (ruleEntry.getIfTrue() != null) {
                    ifTrue = this.translateAgendaTreeDefinition(ruleEntry.getIfTrue());
                }
                if (ruleEntry.getIfFalse() != null) {
                    ifFalse = this.translateAgendaTreeDefinition(ruleEntry.getIfFalse());
                }
                if ((rule = rules.get(ruleEntry.getRuleId())) == null) {
                    throw new IllegalStateException("Failed to locate rule with id: " + ruleEntry.getRuleId());
                }
                BasicAgendaTreeEntry agendaTreeEntry = new BasicAgendaTreeEntry(rule, ifTrue, ifFalse);
                entries.add(agendaTreeEntry);
                continue;
            }
            if (entryDefinition instanceof AgendaTreeSubAgendaEntry) {
                AgendaTreeSubAgendaEntry subAgendaEntry = (AgendaTreeSubAgendaEntry)entryDefinition;
                SubAgenda subAgenda = subAgendas.get(subAgendaEntry.getSubAgendaId());
                if (subAgenda == null) {
                    throw new IllegalStateException("Failed to locate sub agenda with id: " + subAgendaEntry.getSubAgendaId());
                }
                BasicAgendaTreeEntry agendaTreeEntry = new BasicAgendaTreeEntry((Rule)subAgenda, null, null);
                entries.add(agendaTreeEntry);
                continue;
            }
            throw new IllegalStateException("Encountered invalid agenda tree entry class, did not understand type: " + entryDefinition);
        }
        return new BasicAgendaTree(entries);
    }

    protected Map<String, Rule> loadRules(List<String> ruleIds) {
        List ruleDefinitions = this.ruleRepositoryService.getRules(ruleIds);
        this.validateRuleDefinitions(ruleIds, ruleDefinitions);
        HashMap<String, Rule> rules = new HashMap<String, Rule>();
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.put(ruleDefinition.getId(), this.translateRuleDefinition(ruleDefinition));
        }
        return rules;
    }

    private void validateRuleDefinitions(List<String> ruleIds, List<RuleDefinition> ruleDefinitions) {
        if (ruleIds.size() != ruleDefinitions.size()) {
            Map<String, RuleDefinition> indexedRuleDefinitions = this.indexRuleDefinitions(ruleDefinitions);
            for (String ruleId : ruleIds) {
                if (indexedRuleDefinitions.containsKey(ruleId)) continue;
                throw new RepositoryDataException("Failed to locate a rule with id '" + ruleId + "' in the repository.");
            }
        }
    }

    private Map<String, RuleDefinition> indexRuleDefinitions(List<RuleDefinition> ruleDefinitions) {
        HashMap<String, RuleDefinition> ruleDefinitionMap = new HashMap<String, RuleDefinition>();
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            ruleDefinitionMap.put(ruleDefinition.getId(), ruleDefinition);
        }
        return ruleDefinitionMap;
    }

    protected Map<String, SubAgenda> loadSubAgendas(List<String> subAgendaIds) {
        List subAgendaDefinitions = this.ruleRepositoryService.getAgendaTrees(subAgendaIds);
        this.validateSubAgendaDefinitions(subAgendaIds, subAgendaDefinitions);
        HashMap<String, SubAgenda> subAgendas = new HashMap<String, SubAgenda>();
        for (AgendaTreeDefinition subAgendaDefinition : subAgendaDefinitions) {
            subAgendas.put(subAgendaDefinition.getAgendaId(), this.translateAgendaTreeDefinitionToSubAgenda(subAgendaDefinition));
        }
        return subAgendas;
    }

    private void validateSubAgendaDefinitions(List<String> subAgendaIds, List<AgendaTreeDefinition> subAgendaDefinitions) {
        if (subAgendaIds.size() != subAgendaDefinitions.size()) {
            Map<String, AgendaTreeDefinition> indexedSubAgendaDefinitions = this.indexSubAgendaDefinitions(subAgendaDefinitions);
            for (String subAgendaId : subAgendaIds) {
                if (indexedSubAgendaDefinitions.containsKey(subAgendaId)) continue;
                throw new RepositoryDataException("Failed to locate an agenda with id '" + subAgendaId + "' in the repository.");
            }
        }
    }

    private Map<String, AgendaTreeDefinition> indexSubAgendaDefinitions(List<AgendaTreeDefinition> subAgendaDefinitions) {
        HashMap<String, AgendaTreeDefinition> subAgendaDefinitionMap = new HashMap<String, AgendaTreeDefinition>();
        for (AgendaTreeDefinition subAgendaDefinition : subAgendaDefinitions) {
            subAgendaDefinitionMap.put(subAgendaDefinition.getAgendaId(), subAgendaDefinition);
        }
        return subAgendaDefinitionMap;
    }

    @Override
    public Rule translateRuleDefinition(RuleDefinition ruleDefinition) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (ruleDefinition.getActions() != null) {
            for (ActionDefinition actionDefinition : ruleDefinition.getActions()) {
                actions.add(this.translateActionDefinition(actionDefinition));
            }
        }
        return new LazyRule(ruleDefinition, this.typeResolver);
    }

    @Override
    public Proposition translatePropositionDefinition(PropositionDefinition propositionDefinition) {
        return new LazyProposition(propositionDefinition, this.typeResolver);
    }

    @Override
    public Action translateActionDefinition(ActionDefinition actionDefinition) {
        if (actionDefinition.getTypeId() == null) {
            throw new RepositoryDataException("Given ActionDefinition does not have a typeId, actionId was: " + actionDefinition.getId());
        }
        return new LazyAction(actionDefinition, this.typeResolver);
    }

    @Override
    public List<Action> translateActionDefinitions(List<ActionDefinition> actionDefinitions) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (ActionDefinition actionDefinition : actionDefinitions) {
            actions.add(this.translateActionDefinition(actionDefinition));
        }
        return actions;
    }

    @Override
    public SubAgenda translateAgendaTreeDefinitionToSubAgenda(AgendaTreeDefinition subAgendaDefinition) {
        return new SubAgenda(this.translateAgendaTreeDefinition(subAgendaDefinition));
    }

    public void setRuleRepositoryService(RuleRepositoryService ruleRepositoryService) {
        this.ruleRepositoryService = ruleRepositoryService;
    }

    public void setTypeResolver(KrmsTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public TermRepositoryService getTermRepositoryService() {
        return this.termRepositoryService;
    }

    public void setTermRepositoryService(TermRepositoryService termRepositoryService) {
        this.termRepositoryService = termRepositoryService;
    }
}

