/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;

public class TermRepositoryServiceMockImpl
implements TermRepositoryService {
    private Map<String, TermDefinition> termMap = new LinkedHashMap<String, TermDefinition>();
    private Map<String, TermSpecificationDefinition> termSpecificationMap = new LinkedHashMap<String, TermSpecificationDefinition>();
    private Map<String, TermResolverDefinition> termResolverMap = new LinkedHashMap<String, TermResolverDefinition>();

    public void clear() {
        this.termMap.clear();
        this.termSpecificationMap.clear();
        this.termResolverMap.clear();
    }

    public List<TermResolverDefinition> findTermResolversByNamespace(String namespace) throws RiceIllegalArgumentException {
        ArrayList<TermResolverDefinition> list = new ArrayList<TermResolverDefinition>();
        for (TermResolverDefinition info : this.termResolverMap.values()) {
            if (!info.getNamespace().equals(namespace)) continue;
            list.add(info);
        }
        return list;
    }

    public TermDefinition getTerm(String termId) throws RiceIllegalArgumentException {
        if (!this.termMap.containsKey(termId)) {
            throw new RiceIllegalArgumentException(termId);
        }
        return this.termMap.get(termId);
    }

    public TermSpecificationDefinition getTermSpecificationById(String id) throws RiceIllegalArgumentException {
        if (!this.termSpecificationMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.termSpecificationMap.get(id);
    }

    public TermSpecificationDefinition createTermSpecification(TermSpecificationDefinition termSpec) throws RiceIllegalArgumentException {
        try {
            TermSpecificationDefinition orig = this.getTermSpecificationById(termSpec.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(termSpec.getId() + "." + termSpec.getName());
            }
        }
        catch (RiceIllegalArgumentException orig) {
            // empty catch block
        }
        TermSpecificationDefinition.Builder copy = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        TermSpecificationDefinition termSpecDefinition = copy.build();
        this.termSpecificationMap.put(termSpecDefinition.getId(), termSpecDefinition);
        return termSpecDefinition;
    }

    public TermDefinition createTerm(TermDefinition termDef) throws RiceIllegalArgumentException {
        try {
            TermDefinition orig = this.getTerm(termDef.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(termDef.getId());
            }
        }
        catch (RiceIllegalArgumentException orig) {
            // empty catch block
        }
        TermDefinition.Builder copy = TermDefinition.Builder.create((TermDefinitionContract)termDef);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        TermDefinition termDefinition = copy.build();
        this.termMap.put(termDefinition.getId(), termDefinition);
        return termDefinition;
    }

    public TermResolverDefinition getTermResolverById(String id) throws RiceIllegalArgumentException {
        if (!this.termResolverMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.termResolverMap.get(id);
    }

    public List<TermResolverDefinition> findTermResolversByOutputId(String id, String namespace) throws RiceIllegalArgumentException {
        ArrayList<TermResolverDefinition> list = new ArrayList<TermResolverDefinition>();
        for (TermResolverDefinition info : this.termResolverMap.values()) {
            if (!info.getNamespace().equals(namespace) || !info.getOutput().getId().equals(id)) continue;
            list.add(info);
        }
        return list;
    }

    public TermResolverDefinition createTermResolver(TermResolverDefinition termResolver) throws RiceIllegalArgumentException {
        try {
            TermResolverDefinition orig = this.getTermResolverById(termResolver.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(termResolver.getId() + "." + termResolver.getName());
            }
        }
        catch (RiceIllegalArgumentException orig) {
            // empty catch block
        }
        TermResolverDefinition.Builder copy = TermResolverDefinition.Builder.create((TermResolverDefinitionContract)termResolver);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        TermResolverDefinition termResolverDefinition = copy.build();
        this.termResolverMap.put(termResolverDefinition.getId(), termResolverDefinition);
        return termResolverDefinition;
    }

    public void updateTermSpecification(TermSpecificationDefinition termSpec) throws RiceIllegalArgumentException {
        TermSpecificationDefinition existing = this.getTermSpecificationById(termSpec.getId());
        if (existing == null) {
            throw new RiceIllegalArgumentException(termSpec.getId() + " does not exist");
        }
        this.termSpecificationMap.put(termSpec.getId(), termSpec);
    }

    public void deleteTermSpecification(String id) throws RiceIllegalArgumentException {
        if (this.termSpecificationMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id + " does not exist");
        }
    }

    public void updateTerm(TermDefinition termDef) throws RiceIllegalArgumentException {
        TermDefinition existing = this.getTerm(termDef.getId());
        if (existing == null) {
            throw new RiceIllegalArgumentException(termDef.getId() + " does not exist");
        }
        this.termMap.put(termDef.getId(), termDef);
    }

    public void deleteTerm(String id) throws RiceIllegalArgumentException {
        if (this.termMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id + " does not exist");
        }
    }

    public void updateTermResolver(TermResolverDefinition termResolver) throws RiceIllegalArgumentException {
        TermResolverDefinition existing = this.getTermResolverById(termResolver.getId());
        if (existing == null) {
            throw new RiceIllegalArgumentException(termResolver.getId() + " does not exist");
        }
        this.termResolverMap.put(termResolver.getId(), termResolver);
    }

    public void deleteTermResolver(String id) throws RiceIllegalArgumentException {
        if (this.termResolverMap.remove(id) == null) {
            throw new RiceIllegalArgumentException(id + " does not exist");
        }
    }

    public TermResolverDefinition getTermResolverByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (name == null || name.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("name is " + name);
        }
        if (namespace == null || namespace.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("namespace is " + namespace);
        }
        for (TermResolverDefinition info : this.termResolverMap.values()) {
            if (!namespace.equals(info.getNamespace()) || !name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    public TermSpecificationDefinition getTermSpecificationByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (name == null || name.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("name is " + name);
        }
        if (namespace == null || namespace.trim().isEmpty()) {
            throw new RiceIllegalArgumentException("namespace is " + namespace);
        }
        for (TermSpecificationDefinition info : this.termSpecificationMap.values()) {
            if (!namespace.equals(info.getNamespace()) || !name.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    public List<TermSpecificationDefinition> findAllTermSpecificationsByContextId(String contextId) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support this operation");
    }
}

