/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.Main;
import net.sourceforge.schemaspy.SchemaAnalyzer;
import net.sourceforge.schemaspy.model.ProcessExecutionException;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlMultipleSchemasIndexPage;

public final class MultipleSchemaAnalyzer {
    private static MultipleSchemaAnalyzer instance = new MultipleSchemaAnalyzer();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final boolean fineEnabled = this.logger.isLoggable(Level.FINE);

    private MultipleSchemaAnalyzer() {
    }

    public static MultipleSchemaAnalyzer getInstance() {
        return instance;
    }

    public void analyze(String string, DatabaseMetaData databaseMetaData, String string2, List<String> list, List<String> list2, Config config) throws SQLException, IOException {
        List<String> list3;
        long l = System.currentTimeMillis();
        String string3 = Config.getLoadedFromJar();
        File file = config.getOutputDir();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("java");
        arrayList.add("-Doneofmultipleschemas=true");
        if (new File(string3).isDirectory()) {
            arrayList.add("-cp");
            arrayList.add(string3);
            arrayList.add(Main.class.getName());
        } else {
            arrayList.add("-jar");
            arrayList.add(string3);
        }
        list2 = new ArrayList<String>(list2);
        list2.remove("-all");
        SchemaAnalyzer.yankParam(list2, "-o");
        SchemaAnalyzer.yankParam(list2, "-s");
        SchemaAnalyzer.yankParam(list2, "-p");
        SchemaAnalyzer.yankParam(list2, "-i");
        SchemaAnalyzer.yankParam(list2, "-I");
        SchemaAnalyzer.yankParam(list2, "-x");
        SchemaAnalyzer.yankParam(list2, "-X");
        for (String object22 : list2) {
            if (object22.startsWith("-")) {
                arrayList.add(object22);
                continue;
            }
            arrayList.add("\"" + object22 + "\"");
        }
        if (list == null) {
            System.out.println("Analyzing schemas that match regular expression '" + string2 + "':");
            System.out.println("(use -schemaSpec on command line or in .properties to exclude other schemas)");
            list3 = this.getPopulatedSchemas(databaseMetaData, string2, false);
            if (list3.isEmpty()) {
                list3 = this.getPopulatedSchemas(databaseMetaData, string2, true);
            }
            if (list3.isEmpty()) {
                list3 = Arrays.asList(config.getUser());
            }
        } else {
            System.out.println("Analyzing schemas:");
            list3 = list;
        }
        for (String string4 : list3) {
            System.out.print(" " + string4);
        }
        System.out.println();
        this.writeIndexPage(string, list3, databaseMetaData, file, config.getCharset());
        Map<String, String> map = System.getenv();
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList2.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        arrayList2.add((CallSite)((Object)("schemaspy.pw=" + config.getPassword())));
        arrayList2.add((CallSite)((Object)("schemaspy.tableInclusions=" + config.getTableInclusions())));
        arrayList2.add((CallSite)((Object)("schemaspy.tableExclusions=" + config.getTableExclusions())));
        arrayList2.add((CallSite)((Object)("schemaspy.columnExclusions=" + config.getColumnExclusions())));
        arrayList2.add((CallSite)((Object)("schemaspy.indirectColumnExclusions=" + config.getIndirectColumnExclusions())));
        for (String string5 : list3) {
            ArrayList<String> arrayList3 = new ArrayList<String>(arrayList);
            if (string == null) {
                arrayList3.add("-db");
            } else {
                arrayList3.add("-s");
            }
            arrayList3.add(string5);
            arrayList3.add("-o");
            arrayList3.add(new File(file, string5).toString());
            System.out.println("Analyzing " + string5);
            System.out.flush();
            this.logger.fine("Analyzing schema with: " + arrayList3);
            Process process = Runtime.getRuntime().exec(arrayList3.toArray(new String[0]), arrayList2.toArray(new String[0]));
            new ProcessOutputReader(process.getInputStream(), System.out).start();
            new ProcessOutputReader(process.getErrorStream(), System.err).start();
            try {
                int n = process.waitFor();
                if (n == 0) continue;
                StringBuilder stringBuilder = new StringBuilder("Failed to execute this process (rc " + n + "):");
                for (String string6 : arrayList3) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string6);
                }
                throw new ProcessExecutionException(stringBuilder.toString());
            }
            catch (InterruptedException interruptedException) {
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Wrote relationship details of " + list3.size() + " schema" + (list3.size() == 1 ? "" : "s") + " in " + (l2 - l) / 1000L + " seconds.");
        System.out.println("Start with " + new File(file, "index.html"));
    }

    public void analyze(String string, List<String> list, List<String> list2, Config config) throws SQLException, IOException {
        this.analyze(string, null, null, list, list2, config);
    }

    private void writeIndexPage(String string, List<String> list, DatabaseMetaData databaseMetaData, File file, String string2) throws IOException {
        if (list.size() > 0) {
            LineWriter lineWriter = new LineWriter(new File(file, "index.html"), string2);
            HtmlMultipleSchemasIndexPage.getInstance().write(string, list, databaseMetaData, lineWriter);
            lineWriter.close();
        }
    }

    private List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData, String string, boolean bl) throws SQLException {
        List<String> list;
        if (!bl && databaseMetaData.supportsSchemasInTableDefinitions() || bl && databaseMetaData.supportsCatalogsInTableDefinitions()) {
            Pattern pattern = Pattern.compile(string);
            list = DbAnalyzer.getPopulatedSchemas(databaseMetaData, string, bl);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (!pattern.matcher(string2).matches()) {
                    if (this.fineEnabled) {
                        this.logger.fine("Excluding schema " + string2 + ": doesn't match + \"" + pattern + "\"");
                    }
                    iterator.remove();
                    continue;
                }
                if (!this.fineEnabled) continue;
                this.logger.fine("Including schema " + string2 + ": matches + \"" + pattern + "\"");
            }
        } else {
            list = new ArrayList<String>();
        }
        return list;
    }

    private static class ProcessOutputReader
    extends Thread {
        private final Reader processReader;
        private final PrintStream out;

        ProcessOutputReader(InputStream inputStream, PrintStream printStream) {
            this.processReader = new InputStreamReader(inputStream);
            this.out = printStream;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                int n;
                while ((n = this.processReader.read()) != -1) {
                    this.out.print((char)n);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    this.processReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

