/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.schemaspy.model.RoutineParameter;

public class Routine
implements Comparable<Routine> {
    private final String name;
    private final String type;
    private final String definitionLanguage;
    private final String definition;
    private final boolean deterministic;
    private final String dataAccess;
    private final String securityType;
    private final String comment;
    private final String returnType;
    private final List<RoutineParameter> params = new ArrayList<RoutineParameter>();
    private static Comparator<String> nullSafeStringComparator = Comparator.nullsFirst(String::compareTo);
    private static Comparator<Routine> routineComparator = Comparator.comparing(Routine::getName, nullSafeStringComparator).thenComparing(Routine::getType, nullSafeStringComparator).thenComparing(Routine::getReturnType, nullSafeStringComparator).thenComparing(Routine::getDefinition, nullSafeStringComparator);

    public Routine(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, String string8) {
        this.name = string;
        this.type = string2;
        this.returnType = string3;
        this.definitionLanguage = string4;
        this.definition = string5;
        this.dataAccess = string6;
        this.securityType = string7;
        this.deterministic = bl;
        this.comment = string8;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDefinitionLanguage() {
        return this.definitionLanguage;
    }

    public String getDefinition() {
        return this.definition;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDataAccess() {
        return this.dataAccess;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void addParameter(RoutineParameter routineParameter) {
        this.params.add(routineParameter);
    }

    public List<RoutineParameter> getParameters() {
        return this.params;
    }

    @Override
    public int compareTo(Routine routine) {
        return routineComparator.compare(this, routine);
    }
}

