/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embeddable;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.krad.bo.KualiCode;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public class KualiCodeBase
extends PersistableBusinessObjectBase
implements KualiCode,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1194744068788100482L;
    @Id
    @Column(name="CODE", length=10)
    protected String code;
    @Column(name="NM", length=40)
    protected String name;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected Boolean active;

    public KualiCodeBase() {
        this.active = true;
    }

    public KualiCodeBase(String code) {
        this();
        this.code = code;
    }

    public String getCode() {
        return this._persistence_get_code();
    }

    public void setCode(String code) {
        this._persistence_set_code(code);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean a) {
        this._persistence_set_active(a);
    }

    public String getCodeAndDescription() {
        return KualiCodeBase.getCodeAndDescription(this.getCode(), this.getName());
    }

    public static String getCodeAndDescription(String code, String desc) {
        if (code != null) {
            if (desc == null) {
                return code;
            }
            return code + " - " + desc;
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof KualiCodeBase) {
            return StringUtils.equals((String)this.getCode(), (String)((KualiCodeBase)obj).getCode());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getCode() != null) {
            hashCode = this.getCode().hashCode();
        }
        return hashCode;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new KualiCodeBase(persistenceObject);
    }

    public KualiCodeBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "code") {
            return this.code;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "active") {
            return this.active;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "code") {
            this.code = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_code() {
        this._persistence_checkFetched("code");
        return this.code;
    }

    public void _persistence_set_code(String string) {
        this._persistence_checkFetchedForSet("code");
        this._persistence_propertyChange("code", this.code, string);
        this.code = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", this.active, bl);
        this.active = bl;
    }

    @Embeddable
    private static final class WeaveMe
    extends KualiCodeBase
    implements PersistenceWeaved,
    PersistenceObject,
    PersistenceWeavedFetchGroups,
    PersistenceWeavedChangeTracking {
        static final long serialVersionUID = -2133354157935630231L;

        private WeaveMe() {
        }

        @Override
        public Object _persistence_post_clone() {
            Object object = super._persistence_post_clone();
            this._persistence_listener = null;
            this._persistence_fetchGroup = null;
            this._persistence_session = null;
            return this;
        }

        @Override
        public Object _persistence_new(PersistenceObject persistenceObject) {
            return new WeaveMe(persistenceObject);
        }

        public WeaveMe(PersistenceObject persistenceObject) {
            super(persistenceObject);
        }

        @Override
        public Object _persistence_get(String string) {
            return super._persistence_get(string);
        }

        @Override
        public void _persistence_set(String string, Object object) {
            super._persistence_set(string, object);
        }
    }
}

