/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LookupDaoProxy
implements LookupDao {
    private LookupDao lookupDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static Map<String, LookupDao> lookupDaoValues;

    public void setLookupDaoOjb(LookupDao lookupDaoOjb) {
        this.lookupDaoOjb = lookupDaoOjb;
    }

    private LookupDao getDao(Class clazz) {
        ModuleService moduleService = LookupDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (lookupDaoValues.get(dataSourceName) != null) {
                    return lookupDaoValues.get(dataSourceName);
                }
                LookupDaoOjb classSpecificLookupDaoOjb = new LookupDaoOjb();
                classSpecificLookupDaoOjb.setJcdAlias(dataSourceName);
                classSpecificLookupDaoOjb.setPersistenceStructureService(KNSServiceLocator.getPersistenceStructureService());
                classSpecificLookupDaoOjb.setDateTimeService(CoreApiServiceLocator.getDateTimeService());
                classSpecificLookupDaoOjb.setDataDictionaryService(KRADServiceLocatorWeb.getDataDictionaryService());
                lookupDaoValues.put(dataSourceName, classSpecificLookupDaoOjb);
                return classSpecificLookupDaoOjb;
            }
        }
        return this.lookupDaoOjb;
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, Object criteria) {
        return this.getDao(example.getClass()).createCriteria(example, searchValue, propertyName, criteria);
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria) {
        return this.getDao(example.getClass()).createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly) {
        return this.getDao(businessObjectClass).findCollectionBySearchHelper(businessObjectClass, formProps, unbounded, usePrimaryKeyValuesOnly);
    }

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly, Integer searchResultsLimit) {
        return this.getDao(businessObjectClass).findCollectionBySearchHelper(businessObjectClass, formProps, unbounded, usePrimaryKeyValuesOnly, searchResultsLimit);
    }

    public Long findCountByMap(Object example, Map formProps) {
        return this.getDao(example.getClass()).findCountByMap(example, formProps);
    }

    @Override
    public <T> T findObjectByMap(Class<T> type, Map<String, String> formProps) {
        return this.getDao(type).findObjectByMap(type, formProps);
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        lookupDaoValues = Collections.synchronizedMap(new HashMap());
    }
}

