/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jta;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.transaction.UserTransaction;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.core.framework.persistence.jta.Jta;
import org.springframework.beans.factory.FactoryBean;

public class UserTransactionFactoryBean
implements FactoryBean<UserTransaction> {
    public UserTransaction getObject() throws Exception {
        return (UserTransaction)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getObjectType()}, (InvocationHandler)((Object)new LazyInitializationHandler()));
    }

    public Class<UserTransaction> getObjectType() {
        return UserTransaction.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class LazyInitializationHandler
    extends BaseTargetedInvocationHandler<UserTransaction> {
        private volatile boolean initialized;
        private UserTransaction userTransaction;

        LazyInitializationHandler() {
            super(null);
        }

        public Object invokeInternal(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.initialized) {
                if (Jta.isFrozen()) {
                    this.userTransaction = Jta.getUserTransaction();
                    this.initialized = true;
                } else {
                    throw new IllegalStateException("JTA has not been initialized, in order to use the UserTransaction please ensure that it has been configured on " + Jta.class.getName());
                }
            }
            if (this.userTransaction == null) {
                throw new IllegalStateException("Attempting to use TransactionManager but JTA is not enabled.");
            }
            return method.invoke((Object)this.userTransaction, args);
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public UserTransaction getTarget() {
            return this.userTransaction;
        }
    }
}

