/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    private ReflectionUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static <T> T getField(Object object, String name, Class<T> type) {
        Field field = org.springframework.util.ReflectionUtils.findField(object.getClass(), (String)name, type);
        if (field == null) {
            throw new RuntimeException("Could not obtain field '" + name + "'", new NoSuchFieldException(object.getClass() + "." + name));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)object);
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        Class targetClass = clazz;
        do {
            Field[] fields = targetClass.getDeclaredFields();
            allFields.addAll(Arrays.asList(fields));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return allFields;
    }

    public static <T> T invokeViaReflection(Object object, String methodName, Class[] paramTypes, Object ... args) {
        return ReflectionUtils.invokeViaReflection(object.getClass(), object, methodName, paramTypes, args);
    }

    public static <T> T invokeViaReflection(Class clazz, Object object, String methodName, Class[] paramTypes, Object ... args) {
        Method method = org.springframework.util.ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])paramTypes);
        if (method == null) {
            throw new RuntimeException("Could not invoke method '" + methodName + "'", new NoSuchMethodException(clazz + "." + methodName));
        }
        ReflectionUtils.makeAccessible((Method)method);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)object, (Object[])args);
    }

    public static <T> T invokeViaReflection(Object object, String methodName, T defaultReturnValue, Class[] paramTypes, Object ... args) {
        return ReflectionUtils.invokeViaReflection(object.getClass(), object, methodName, defaultReturnValue, paramTypes, args);
    }

    public static <T> T invokeViaReflection(Class clazz, Object object, String methodName, T defaultReturnValue, Class[] paramTypes, Object ... args) {
        Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])paramTypes);
        if (method == null) {
            return defaultReturnValue;
        }
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)object, (Object[])args);
    }
}

