/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.MetadataChild;
import org.kuali.rice.krad.data.util.Link;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class ReferenceLinker {
    private static final Logger LOG = LogManager.getLogger(ReferenceLinker.class);
    private DataObjectService dataObjectService;

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void linkChanges(Object rootObject, Set<String> changedPropertyPaths) {
        if (rootObject == null || CollectionUtils.isEmpty(changedPropertyPaths)) {
            return;
        }
        Class<?> type = rootObject.getClass();
        if (!this.dataObjectService.supports(type)) {
            LOG.info("Object supplied for linking is not a supported data object type: " + type);
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Performing linking on instance of " + type + " with the following changed property paths: " + Arrays.toString(changedPropertyPaths.toArray()));
        }
        Map<String, Set<String>> decomposedPaths = this.decomposePropertyPaths(changedPropertyPaths);
        this.linkChangesInternal(rootObject, decomposedPaths, new HashSet<Object>());
    }

    protected void linkChangesInternal(Object object, Map<String, Set<String>> changedPropertyPaths, Set<Object> linked) {
        if (object == null || linked.contains(object) || !this.dataObjectService.supports(object.getClass()) || changedPropertyPaths.isEmpty()) {
            return;
        }
        linked.add(object);
        DataObjectWrapper<Object> wrapped = this.dataObjectService.wrap(object);
        this.linkRelationshipChanges(wrapped, changedPropertyPaths, linked);
        this.linkCollectionChanges(wrapped, changedPropertyPaths, linked);
        this.cascadeLinkingAnnotations(wrapped, changedPropertyPaths, linked);
    }

    protected void linkRelationshipChanges(DataObjectWrapper<?> wrapped, Map<String, Set<String>> decomposedPaths, Set<Object> linked) {
        List<DataObjectRelationship> relationships = wrapped.getMetadata().getRelationships();
        for (DataObjectRelationship relationship : relationships) {
            Set<String> modifiedPropertyPaths;
            String relationshipName = relationship.getName();
            if (relationship.isSavedWithParent() && decomposedPaths.containsKey(relationshipName)) {
                Object value = wrapped.getPropertyValue(relationshipName);
                Map<String, Set<String>> nextPropertyPaths = this.decomposePropertyPaths(decomposedPaths.get(relationshipName));
                this.linkChangesInternal(value, nextPropertyPaths, linked);
            }
            List<DataObjectAttributeRelationship> attributeRelationships = relationship.getAttributeRelationships();
            boolean modifiedAttributeRelationship = false;
            for (DataObjectAttributeRelationship attributeRelationship : attributeRelationships) {
                if (!decomposedPaths.containsKey(attributeRelationship.getParentAttributeName())) continue;
                modifiedAttributeRelationship = true;
                break;
            }
            if (modifiedAttributeRelationship) {
                wrapped.fetchRelationship(relationshipName, true, true);
                continue;
            }
            if (!decomposedPaths.containsKey(relationshipName)) continue;
            Class<?> targetType = relationship.getRelatedType();
            DataObjectMetadata targetMetadata = this.dataObjectService.getMetadataRepository().getMetadata(targetType);
            if (this.isPrimaryKeyModified(targetMetadata, modifiedPropertyPaths = decomposedPaths.get(relationshipName))) {
                wrapped.fetchRelationship(relationshipName, false, false);
                continue;
            }
            wrapped.linkForeignKeys(relationshipName, false);
        }
    }

    protected void linkCollectionChanges(DataObjectWrapper<?> wrapped, Map<String, Set<String>> decomposedPaths, Set<Object> linked) {
        List<DataObjectCollection> collections = wrapped.getMetadata().getCollections();
        for (DataObjectCollection collectionMetadata : collections) {
            Object collectionValue;
            Set<Integer> modifiedIndicies;
            if (!collectionMetadata.isSavedWithParent() || (modifiedIndicies = this.extractModifiedIndicies(collectionMetadata, decomposedPaths)).isEmpty() || !((collectionValue = wrapped.getPropertyValue(collectionMetadata.getName())) instanceof Iterable)) continue;
            int index = 0;
            for (Object element : (Iterable)collectionValue) {
                if (modifiedIndicies.contains(Integer.MAX_VALUE) || modifiedIndicies.contains(index)) {
                    String pathKey = collectionMetadata.getName() + "[" + index + "]";
                    if (decomposedPaths.containsKey(pathKey)) {
                        Map<String, Set<String>> nextPropertyPaths = this.decomposePropertyPaths(decomposedPaths.get(pathKey));
                        this.linkChangesInternal(element, nextPropertyPaths, linked);
                    }
                    if (this.dataObjectService.supports(element.getClass())) {
                        DataObjectWrapper elementWrapper = this.dataObjectService.wrap(element);
                        this.linkBiDirectionalCollection(wrapped, elementWrapper, collectionMetadata);
                    }
                }
                ++index;
            }
        }
    }

    protected void linkBiDirectionalCollection(DataObjectWrapper<?> parentWrapper, DataObjectWrapper<?> elementWrapper, DataObjectCollection collectionMetadata) {
        MetadataChild inverseRelationship = collectionMetadata.getInverseRelationship();
        if (inverseRelationship != null) {
            elementWrapper.setPropertyValue(inverseRelationship.getName(), parentWrapper.getWrappedInstance());
            elementWrapper.linkForeignKeys(inverseRelationship.getName(), false);
        }
    }

    private Set<Integer> extractModifiedIndicies(DataObjectCollection collectionMetadata, Map<String, Set<String>> decomposedPaths) {
        String relationshipName = collectionMetadata.getName();
        HashSet modifiedIndicies = Sets.newHashSet();
        if (decomposedPaths.containsKey(relationshipName)) {
            modifiedIndicies.add(Integer.MAX_VALUE);
        }
        for (String propertyName : decomposedPaths.keySet()) {
            Integer index;
            if (!relationshipName.equals(PropertyAccessorUtils.getPropertyName((String)relationshipName)) || (index = this.extractIndex(propertyName)) == null) continue;
            modifiedIndicies.add(index);
        }
        return modifiedIndicies;
    }

    private Integer extractIndex(String propertyName) {
        int firstIndex = propertyName.indexOf(91);
        int lastIndex = propertyName.lastIndexOf(93);
        if (firstIndex != -1 && lastIndex != -1) {
            String indexValue = propertyName.substring(firstIndex + 1, lastIndex);
            try {
                int index = Integer.parseInt(indexValue);
                return index;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isPrimaryKeyModified(DataObjectMetadata metadata, Set<String> modifiedPropertyPaths) {
        HashSet<String> primaryKeyAttributeNames = new HashSet<String>(metadata.getPrimaryKeyAttributeNames());
        for (String modifiedPropertyPath : modifiedPropertyPaths) {
            if (!primaryKeyAttributeNames.contains(modifiedPropertyPath)) continue;
            return true;
        }
        return false;
    }

    protected void cascadeLinkingAnnotations(DataObjectWrapper<?> wrapped, Map<String, Set<String>> decomposedPaths, Set<Object> linked) {
        Field[] fields = FieldUtils.getAllFields(wrapped.getWrappedClass());
        HashMap<String, Field> modifiedFieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!decomposedPaths.containsKey(field.getName())) continue;
            modifiedFieldMap.put(field.getName(), field);
        }
        for (String modifiedFieldName : modifiedFieldMap.keySet()) {
            Field modifiedField = (Field)modifiedFieldMap.get(modifiedFieldName);
            Link link = modifiedField.getAnnotation(Link.class);
            if (link == null) {
                link = (Link)AnnotationUtils.findAnnotation(modifiedField.getType(), Link.class);
            }
            if (link == null || !link.cascade()) continue;
            List<String> linkingPaths = this.assembleLinkingPaths(link);
            for (String linkingPath : linkingPaths) {
                Map<String, Set<String>> decomposedLinkingPath = this.decomposePropertyPaths(decomposedPaths.get(modifiedFieldName), linkingPath);
                Object valuePath = modifiedFieldName;
                if (StringUtils.isNotBlank((String)linkingPath)) {
                    valuePath = (String)valuePath + "." + linkingPath;
                }
                Object linkRootObject = wrapped.getPropertyValueNullSafe((String)valuePath);
                this.linkChangesInternal(linkRootObject, decomposedLinkingPath, linked);
            }
        }
    }

    protected List<String> assembleLinkingPaths(Link link) {
        ArrayList<String> linkingPaths = new ArrayList<String>();
        if (ArrayUtils.isEmpty((Object[])link.path())) {
            linkingPaths.add("");
        } else {
            for (String path : link.path()) {
                linkingPaths.add(path);
            }
        }
        return linkingPaths;
    }

    protected Map<String, Set<String>> decomposePropertyPaths(Set<String> changedPropertyPaths) {
        return this.decomposePropertyPaths(changedPropertyPaths, "");
    }

    protected Map<String, Set<String>> decomposePropertyPaths(Set<String> changedPropertyPaths, String prefix) {
        Set<Object> processedProperties = new HashSet();
        if (StringUtils.isNotBlank((String)prefix) && changedPropertyPaths != null) {
            for (String changedPropertyPath : changedPropertyPaths) {
                if (!changedPropertyPath.startsWith(prefix)) continue;
                processedProperties.add(changedPropertyPath.substring(prefix.length() + 1));
            }
        } else {
            processedProperties = changedPropertyPaths;
        }
        HashMap<String, Set<String>> decomposedPropertyPaths = new HashMap<String, Set<String>>();
        for (String string : processedProperties) {
            int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)string);
            if (index == -1) {
                decomposedPropertyPaths.put(string, new HashSet());
                continue;
            }
            String pathEntry = string.substring(0, index);
            HashSet<String> remainingPaths = (HashSet<String>)decomposedPropertyPaths.get(pathEntry);
            if (remainingPaths == null) {
                remainingPaths = new HashSet<String>();
                decomposedPropertyPaths.put(pathEntry, remainingPaths);
            }
            String remainingPath = string.substring(index + 1);
            remainingPaths.add(remainingPath);
        }
        return decomposedPropertyPaths;
    }
}

