/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.coordination.broadcast.BroadcastRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.serializers.JavaSerializer;
import org.eclipse.persistence.sessions.serializers.Serializer;

public class JMSTopicRemoteConnection
extends BroadcastRemoteConnection
implements Runnable {
    protected TopicConnectionFactory topicConnectionFactory;
    protected Topic topic;
    protected boolean isLocal;
    private TopicPublisher publisher;
    protected TopicConnection topicConnection;
    protected TopicSession topicSession;
    protected TopicSubscriber subscriber;
    public static long WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE = 10000L;

    public JMSTopicRemoteConnection(RemoteCommandManager rcm, TopicConnectionFactory topicConnectionFactory, Topic topic, boolean isLocalConnectionBeingCreated, boolean reuseJMSTopicPublisher) throws JMSException {
        super(rcm);
        this.topicConnectionFactory = topicConnectionFactory;
        this.topic = topic;
        this.isLocal = isLocalConnectionBeingCreated;
        rcm.logDebug("creating_broadcast_connection", this.getInfo());
        try {
            if (isLocalConnectionBeingCreated) {
                this.topicConnection = topicConnectionFactory.createTopicConnection();
                this.topicSession = this.topicConnection.createTopicSession(false, 1);
                this.subscriber = this.topicSession.createSubscriber(topic);
                this.topicConnection.start();
                rcm.logDebug("broadcast_connection_created", this.getInfo());
                rcm.getServerPlatform().launchContainerRunnable(this);
            } else if (reuseJMSTopicPublisher) {
                this.topicConnection = topicConnectionFactory.createTopicConnection();
                this.topicSession = this.topicConnection.createTopicSession(false, 1);
                this.setPublisher(this.topicSession.createPublisher(topic));
                rcm.logDebug("broadcast_connection_created", this.getInfo());
            }
        }
        catch (JMSException ex) {
            rcm.logDebug("failed_to_create_broadcast_connection", this.getInfo());
            this.close();
            throw ex;
        }
    }

    public JMSTopicRemoteConnection(RemoteCommandManager rcm) {
        super(rcm);
        this.isLocal = true;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    protected Object executeCommandInternal(Object command) throws Exception {
        try (TopicConnection jmsConnection = null;){
            BytesMessage message;
            TopicPublisher topicPublisher = this.publisher;
            TopicSession publishingSession = this.topicSession;
            if (topicPublisher == null) {
                jmsConnection = this.topicConnectionFactory.createTopicConnection();
                publishingSession = jmsConnection.createTopicSession(false, 1);
                topicPublisher = publishingSession.createPublisher(this.topic);
            }
            if (command instanceof byte[]) {
                message = publishingSession.createBytesMessage();
                message.writeBytes((byte[])command);
            } else {
                message = publishingSession.createObjectMessage();
                ((ObjectMessage)message).setObject((Serializable)command);
            }
            Object[] debugInfo = null;
            if (this.rcm.shouldLogDebugMessage()) {
                debugInfo = this.logDebugBeforePublish(null);
            }
            topicPublisher.publish((Message)message);
            if (debugInfo != null) {
                this.logDebugAfterPublish(debugInfo, message.getJMSMessageID());
            }
            return null;
        }
    }

    public void onMessage(Message message) {
        Object object;
        String messageId;
        block14: {
            String topic = null;
            messageId = "";
            if (this.rcm.shouldLogDebugMessage()) {
                try {
                    messageId = message.getJMSMessageID();
                    this.logDebugOnReceiveMessage(messageId);
                    topic = this.logDebugJMSTopic(message);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            object = null;
            try {
                if (message instanceof ObjectMessage) {
                    object = ((ObjectMessage)message).getObject();
                    break block14;
                }
                if (message instanceof BytesMessage) {
                    BytesMessage byteMessage = (BytesMessage)message;
                    byte[] bytes = new byte[(int)byteMessage.getBodyLength()];
                    byteMessage.readBytes(bytes);
                    Serializer serializer = this.rcm.getSerializer();
                    if (serializer == null) {
                        serializer = JavaSerializer.instance;
                    }
                    object = serializer.deserialize(bytes, (AbstractSession)this.rcm.getCommandProcessor());
                    break block14;
                }
                if (this.rcm.shouldLogWarningMessage() && topic == null) {
                    try {
                        topic = ((Topic)message.getJMSDestination()).getTopicName();
                    }
                    catch (JMSException ex) {
                        topic = "";
                    }
                    Object[] args = new Object[]{message.getClass().getName(), topic};
                    this.rcm.logWarningWithoutLevelCheck("received_unexpected_message_type", args);
                }
                return;
            }
            catch (Exception exception) {
                if (messageId.length() == 0) {
                    try {
                        messageId = message.getJMSMessageID();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                this.failDeserializeMessage(messageId, exception);
                return;
            }
        }
        this.processReceivedObject(object, messageId);
    }

    @Override
    protected boolean areAllResourcesFreedOnClose() {
        return !this.isLocal();
    }

    @Override
    protected void closeInternal() throws JMSException {
        if (this.areAllResourcesFreedOnClose() && this.topicConnection != null) {
            this.topicConnection.close();
        }
    }

    protected String logDebugJMSTopic(Message message) throws JMSException {
        String topic = ((Topic)message.getJMSDestination()).getTopicName();
        Object[] args = new Object[]{topic};
        this.rcm.logDebugWithoutLevelCheck("retreived_remote_message_from_JMS_topic", args);
        return topic;
    }

    @Override
    public void run() {
        boolean shouldReconnect;
        JMSTopicTransportManager tm;
        block22: {
            tm = (JMSTopicTransportManager)this.rcm.getTransportManager();
            this.rcm.logDebug("broadcast_connection_start_listening", this.getInfo());
            shouldReconnect = false;
            RuntimeException messageIsNullException = null;
            while (this.isActive()) {
                try {
                    Message message = this.subscriber.receive();
                    if (!this.isActive()) continue;
                    if (message == null) {
                        try {
                            this.rcm.handleException(RemoteCommandManagerException.errorJMSMessageIsNull());
                            continue;
                        }
                        catch (RuntimeException ex) {
                            messageIsNullException = ex;
                            throw new JMSException("");
                        }
                    }
                    this.rcm.getServerPlatform().launchContainerRunnable(new JMSOnMessageHelper(message));
                }
                catch (JMSException e) {
                    RemoteCommandManagerException rcmException;
                    if (!this.isActive()) continue;
                    if (messageIsNullException != null) {
                        rcmException = RemoteCommandManagerException.errorReceivingJMSMessage(messageIsNullException);
                        messageIsNullException = null;
                    } else {
                        rcmException = RemoteCommandManagerException.errorReceivingJMSMessage((Exception)((Object)e));
                    }
                    if (tm.shouldRemoveConnectionOnError()) {
                        shouldReconnect = true;
                        Object[] args = new Object[]{this.getServiceId(), rcmException};
                        this.rcm.logWarning("drop_connection_on_error", args);
                        tm.removeLocalConnection();
                        continue;
                    }
                    try {
                        this.rcm.handleException(rcmException);
                    }
                    catch (RuntimeException ex) {
                        Object[] args = new Object[]{this.toString(), rcmException, WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE};
                        this.rcm.logWarning("broadcast_listening_sleep_on_error", args);
                        try {
                            Thread.sleep(WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.rcm.logDebug("broadcast_connection_stop_listening", this.getInfo());
            if (this.isClosing()) {
                try {
                    try {
                        this.topicConnection.close();
                    }
                    catch (JMSException closeException) {
                        Object[] args = new Object[]{this.displayString, closeException};
                        this.rcm.logWarning("broadcast_exception_thrown_when_attempting_to_close_connection", args);
                        this.rcm.logDebug("broadcast_connection_closed", this.getInfo());
                        this.state = "CLOSED";
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    this.rcm.logDebug("broadcast_connection_closed", this.getInfo());
                    this.state = "CLOSED";
                    throw throwable;
                }
                this.rcm.logDebug("broadcast_connection_closed", this.getInfo());
                this.state = "CLOSED";
            }
        }
        if (shouldReconnect && !tm.getRemoteCommandManager().isStopped()) {
            try {
                tm.createLocalConnection();
            }
            catch (RemoteCommandManagerException remoteCommandManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void createDisplayString() {
        super.createDisplayString();
        this.displayString = String.valueOf(this.isLocal() ? "Local " : "External ") + this.displayString;
    }

    @Override
    protected boolean shouldCheckServiceId() {
        return true;
    }

    public void setPublisher(TopicPublisher publisher) {
        this.publisher = publisher;
    }

    public TopicPublisher getPublisher() {
        return this.publisher;
    }

    public void setSuscriber(TopicSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public TopicSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setTopicSession(TopicSession topicSession) {
        this.topicSession = topicSession;
    }

    public TopicSession getTopicSession() {
        return this.topicSession;
    }

    public void setTopicConnectionFactory(TopicConnectionFactory topicConnectionFactory) {
        this.topicConnectionFactory = topicConnectionFactory;
    }

    public TopicConnection getTopicConnectionFactory() {
        return this.topicConnection;
    }

    public void setTopicConnection(TopicConnection topicConnection) {
        this.topicConnection = topicConnection;
    }

    public TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public Topic getTopic() {
        return this.topic;
    }

    class JMSOnMessageHelper
    implements Runnable {
        Message message = null;

        public JMSOnMessageHelper(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            JMSTopicRemoteConnection.this.onMessage(this.message);
        }
    }
}

